/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.luminance.config.LuminanceConfigHelper;
import com.mclegoman.perspective.client.config.PerspectiveDefaultConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import com.mclegoman.perspective.client.logo.PerspectiveLogo;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.update.Update;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.client.gui.widget.*;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractConfigScreen extends class_437 {
	protected int page;
	protected final class_437 parentScreen;
	protected final class_7845 grid;
	protected class_7845.class_7939 gridAdder;
	protected boolean shouldClose;
	public AbstractConfigScreen(class_437 parentScreen, int page) {
		super(class_2561.method_43470(""));
		this.grid = new class_7845();
		this.parentScreen = parentScreen;
		this.page = page;
	}
	public void method_25426() {
		super.method_25426();
		this.grid.method_46458().method_46467().method_46464(getGridMargin());
		this.gridAdder = grid.method_47610(1);
		this.gridAdder.method_47613(new class_7852(20, 20), 1);
		this.gridAdder.method_47613(new class_7852(20, 20), 1);
		this.gridAdder.method_47613(new class_7852(20, 20), 1);
	}
	public void postInit() {
		this.gridAdder.method_47612(createFooter());
		this.grid.method_48222();
		this.grid.method_48206(this::method_37063);
		initTabNavigation();
	}
	public void method_25393() {
		try {
			if (this.isDefaults) {
				this.defaultsTicksRemaining--;
				if (this.defaultsTicksRemaining <= 0) {
					this.isDefaults = false;
					this.defaultsTicksRemaining = 0;
				}
			}
			if (this.shouldClose) {
				setParentScreen();
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to tick perspective$config screen: {}", error));
		}
	}
	protected void setParentScreen() {
		ClientData.minecraft.method_1507(this.parentScreen);
	}
	protected class_7845 createFooter() {
		class_7845 footerGrid = new class_7845();
		footerGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 footerGridAdder = footerGrid.method_47610(3);
		try {
			footerGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "reset"), (button) -> {
				PerspectiveConfig.reset(false);
				ClientData.minecraft.method_1507(getRefreshScreen());
			}).build());
			footerGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "back"), (button) -> {
				if (this.page <= 1) {
					this.shouldClose = true;
				} else {
					this.page -= 1;
					ClientData.minecraft.method_1507(getRefreshScreen());
				}
			}).width(73).build());
			class_4185 nextButtonWidget = class_4185.method_46430(Translation.getConfigTranslation(Data.getVersion().getID(), "next"), (button) -> {
				if (!(this.page >= getMaxPage())) {
					this.page += 1;
					ClientData.minecraft.method_1507(getRefreshScreen());
				}
			}).method_46432(73).method_46431();
			if (this.page >= getMaxPage()) nextButtonWidget.field_22763 = false;
			footerGridAdder.method_47612(nextButtonWidget);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "An error occurred whilst creating config footer: " + error.getLocalizedMessage());
		}
		return footerGrid;
	}
	public void initTabNavigation() {
		class_7843.method_48634(this.grid, method_48202());
	}
	public class_2561 method_25435() {
		return class_5244.method_37111();
	}
	public boolean method_25422() {
		return false;
	}
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (keyCode == GLFW.GLFW_KEY_ESCAPE || keyCode == KeyBindingHelper.getBoundKeyOf(Keybindings.openConfig).method_1444()) {
			if (page <= 1) {
				this.shouldClose = true;
			} else {
				this.page -= 1;
				ClientData.minecraft.method_1507(getRefreshScreen());
			}
		}
		return super.method_25404(keyCode, scanCode, modifiers);
	}
	public boolean method_16803(int keyCode, int scanCode, int modifiers) {
		if (keyCode == GLFW.GLFW_KEY_F5) {
			if (method_25441()) {
				PerspectiveConfig.init();
			}
			else Update.checkForUpdates(Data.getVersion(), true);
		}
		if (method_25441() && keyCode == GLFW.GLFW_KEY_S) {
			PerspectiveDefaultConfig.setDefaults(true);
			this.setDefaults("defaults.saved");
		}
		if (method_25441() && method_25443() && keyCode == GLFW.GLFW_KEY_D) {
			LuminanceConfigHelper.reset(PerspectiveDefaultConfig.config, true);
			this.setDefaults("defaults.reset");
		}
		return super.method_16803(keyCode, scanCode, modifiers);
	}
	private boolean isDefaults;
	private int defaultsTicksRemaining;
	private String defaultsType;
	private void setDefaults(String type) {
		this.isDefaults = true;
		this.defaultsTicksRemaining = 20;
		this.defaultsType = type;
	}
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_25394(context, mouseX, mouseY, delta);
		if (this.isDefaults) context.method_27535(field_22793, Translation.getConfigTranslation(Data.getVersion().getID(), this.defaultsType), this.field_22789 - field_22793.method_27525(Translation.getConfigTranslation(Data.getVersion().getID(), this.defaultsType)) - 2, 2, 0xFFFFFF);
		context.method_27535(field_22793, Translation.getTranslation(Data.getVersion().getID(), "version", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name", new class_124[]{class_124.field_1068}), Translation.getText(Data.getVersion().getFriendlyString(), false, new class_124[]{class_124.field_1068})}), 2, this.field_22790 - 10, 0xFFFFFF);
		class_2561 licenceText = Translation.getTranslation(Data.getVersion().getID(), "license", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name", new class_124[]{class_124.field_1068}), Translation.getText(Data.getVersion().getFriendlyString(false), false, new class_124[]{class_124.field_1068})});
		context.method_27535(field_22793, licenceText, this.field_22789 - this.field_22793.method_27525(licenceText) - 2, this.field_22790 - 10, 0xFFFFFF);
		getLogoWidget(this.field_22789 / 2 - 128, 30, getExperimental()).method_48579(context, mouseX, mouseY, delta);
		context.method_27534(field_22793, getPageTitle(), this.field_22789 / 2, 78, 0xFFFFFF);
		if (isBeingReworked()) context.method_27534(field_22793, Translation.getConfigTranslation(Data.getVersion().getID(), "warning.reworked", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), getReworkedId())}, new class_124[]{class_124.field_1061, class_124.field_1067}), ClientData.minecraft.method_22683().method_4486() / 2, 10, 0xFFFFFF);
		if (canShowUpdate() && isUpdateAvailable()) context.method_27535(field_22793, Translation.getConfigTranslation(Data.getVersion().getID(), "update.title"), 2, 2, 0xFFAA00);
	}
	public class_437 getRefreshScreen() {
		return this;
	}
	public class_2561 getPageTitle() {
		return !getPageId().isEmpty() ? Translation.getConfigTranslation(Data.getVersion().getID(), getPageId()) : class_2561.method_43473();
	}
	public String getPageId() {
		return "";
	}
	public int getMaxPage() {
		return 1;
	}
	public int getGridMargin() {
		return 2;
	}
	public boolean getExperimental() {
		return false;
	}
	public PerspectiveLogo.Widget getLogoWidget(int x, int y, boolean experimental) {
		return new PerspectiveLogo.Widget(x, y, experimental);
	}
	public boolean isBeingReworked() {
		return false;
	}
	public String getReworkedId() {
		return getPageId();
	}
	public boolean canShowUpdate() {
		return true;
	}
	public boolean isUpdateAvailable() {
		return Update.isNewerVersionFound();
	}

	public void method_25410(class_310 client, int width, int height) {
		super.method_25410(client, width, height);
		ClientData.minecraft.method_1507(getRefreshScreen());
	}
}
