/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.PerspectiveDefaultConfig;
import com.mclegoman.perspective.client.screen.config.events.EventsConfigScreen;
import com.mclegoman.perspective.client.screen.config.overlays.OverlaysConfigScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.toasts.PerspectiveToast;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.config.hide.HideConfigScreen;
import com.mclegoman.perspective.client.screen.config.hold_perspective.HoldPerspectiveConfigScreen;
import com.mclegoman.perspective.client.screen.config.information.InformationScreen;
import com.mclegoman.perspective.client.screen.config.shaders.ShadersConfigScreen;
import com.mclegoman.perspective.client.screen.config.textured_entity.TexturedEntityConfigScreen;
import com.mclegoman.perspective.client.screen.config.zoom.ZoomConfigScreen;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.update.Update;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.client.gui.widget.*;

public class ConfigScreen extends AbstractConfigScreen {
	public ConfigScreen(class_437 parentScreen, int page) {
		super(parentScreen, page);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createPageOne());
			else if (this.page == 2) this.gridAdder.method_47612(createPageTwo());
			else shouldClose = true;
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	protected void setParentScreen() {
		PerspectiveConfig.config.save();
		PerspectiveDefaultConfig.config.save();
		super.setParentScreen();
	}
	private class_7845 createPageOne() {
		class_7845 grid = new class_7845();
		grid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 gridAdder = grid.method_47610(2);
		try {
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom"), (button) -> ClientData.minecraft.method_1507(new ZoomConfigScreen(getRefreshScreen(), 1))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders"), (button) -> ClientData.minecraft.method_1507(new ShadersConfigScreen(getRefreshScreen()))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "textured_entity"), (button) -> ClientData.minecraft.method_1507(new TexturedEntityConfigScreen(getRefreshScreen()))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "events"), (button) -> ClientData.minecraft.method_1507(new EventsConfigScreen(getRefreshScreen(), 1))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide"), (button) -> ClientData.minecraft.method_1507(new HideConfigScreen(getRefreshScreen(), 1))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective"), (button) -> ClientData.minecraft.method_1507(new HoldPerspectiveConfigScreen(getRefreshScreen(), 1))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays"), (button) -> ClientData.minecraft.method_1507(new OverlaysConfigScreen(getRefreshScreen(), 1))).build());
			gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "show_death_coordinates", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.showDeathCoordinates.value(), Translation.Type.ONFF)}), (button) -> PerspectiveConfig.toggle(PerspectiveConfig.config.showDeathCoordinates)).build());
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/page1: " + error.getLocalizedMessage());
		}
		return grid;
	}
	private class_7845 createPageTwo() {
		class_7845 grid = new class_7845();
		grid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 gridAdder = grid.method_47610(2);
		try {
			gridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "tutorials", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.tutorials.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.tutorials);
			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "tutorials", true))).width(304).build(), 2);
			gridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "detect_update_channel", new Object[]{Translation.getDetectUpdateChannelTranslation(Data.getVersion().getID(), PerspectiveConfig.config.detectUpdateChannel.value())}), (button) -> {
				PerspectiveConfig.config.detectUpdateChannel.setValue(Update.nextUpdateChannel(), false);
			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "detect_update_channel", true))).width(304).build(), 2);
			gridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "information"), (button) -> ClientData.minecraft.method_1507(new InformationScreen(getRefreshScreen()))).width(304).build(), 2);
			class_4185 experimental = class_4185.method_46430(Translation.getConfigTranslation(Data.getVersion().getID(), "experimental"), (button) -> {}).method_46432(304).method_46431();
			experimental.field_22763 = PerspectiveToast.Helper.experimentsAvailable;
			gridAdder.method_47613(experimental, 2);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/page2: " + error.getLocalizedMessage());
		}
		return grid;
	}
	public class_437 getRefreshScreen() {
		return new ConfigScreen(this.parentScreen, this.page);
	}
	public String getPageId() {
		return "config";
	}
	public int getMaxPage() {
		return 2;
	}
}