/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_156;
import net.minecraft.class_437;
import net.minecraft.class_7852;
import net.minecraft.class_7940;

public class LinkScreen extends AbstractConfigScreen {
	private final String url;
	private final boolean trusted;
	public LinkScreen(class_437 parentScreen, String url, boolean trusted) {
		super(parentScreen, 1);
		this.url = url;
		this.trusted = trusted;
	}
	public void method_25426() {
		try {
			this.grid.method_46458().method_46467().method_46464(2);
			this.gridAdder = grid.method_47610(3);
			this.gridAdder.method_47613(new class_7852(20, 20), 3);
			this.gridAdder.method_47613(new class_7940(Translation.getText(this.trusted ? "chat.link.confirmTrusted" : "chat.link.confirm", true), ClientData.minecraft.field_1772).method_48981(true), 3);
			this.gridAdder.method_47613(new class_7940(Translation.getText(this.url, false), ClientData.minecraft.field_1772).method_48981(true), 3);
			this.gridAdder.method_47613(new class_7852(20, 20), 3);
			this.gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getText("chat.link.open", true), (button) -> {
				class_156.method_668().method_670(this.url);
				ClientData.minecraft.method_1507(this.parentScreen);
			}).width(100).build());
			this.gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getText("chat.copy", true), (button) -> {
				ClientData.minecraft.field_1774.method_1455(this.url);
				ClientData.minecraft.method_1507(this.parentScreen);
			}).width(100).build());
			this.gridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getText("gui.cancel", true), (button) -> ClientData.minecraft.method_1507(this.parentScreen)).width(100).build());
			if (this.page != 1) shouldClose = true;
			this.grid.method_48222();
			this.grid.method_48206(this::method_37063);
			initTabNavigation();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize link screen: {}", getPageTitle(), error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
}
