/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.events;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class EventsConfigScreen extends AbstractConfigScreen {
	public EventsConfigScreen(class_437 parentScreen, int page) {
		super(parentScreen, page);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createPageOne());
			else shouldClose = true;
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize {} config screen: {}", getPageTitle(), error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createPageOne() {
		class_7845 eventsGrid = new class_7845();
		eventsGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 eventsGridAdder = eventsGrid.method_47610(2);
		try {
			eventsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "PerspectiveEvents.april_fools_prank.allow", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.allowAprilFools.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.allowAprilFools, false);
			}).build());
			eventsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "PerspectiveEvents.april_fools_prank.force", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.forceAprilFools.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.forceAprilFools, false);
			}).build());
			eventsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "PerspectiveEvents.halloween.allow", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.allowHalloween.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.allowHalloween, false);
			}).build());
			eventsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "PerspectiveEvents.halloween.force", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.forceHalloween.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.forceHalloween, false);
			}).build());
			eventsGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "force_pride", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.forcePride.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.forcePride);
			}).width(304).build(), 2);
			eventsGridAdder.method_47613(new class_7852(20, 20), 2);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/events/page1: " + error.getLocalizedMessage());
		}
		return eventsGrid;
	}
	public class_437 getRefreshScreen() {
		return new EventsConfigScreen(this.parentScreen, this.page);
	}
	public String getPageId() {
		return "events";
	}
}