/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.hide;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.screen.widget.ConfigSliderWidget;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.hide.Hide;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class HideConfigScreen extends AbstractConfigScreen {
	public HideConfigScreen(class_437 parentScreen, int page) {
		super(parentScreen, page);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createPageOne());
			else shouldClose = true;
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize zoom config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createPageOne() {
		class_7845 hideGrid = new class_7845();
		hideGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 hideGridAdder = hideGrid.method_47610(2);
		try {
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.block_outline", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), !PerspectiveConfig.config.hideBlockOutline.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.hideBlockOutline, false);

			}).build());
			double blockOutlineLevel = (double) PerspectiveConfig.config.blockOutline.value() / 100;
			hideGridAdder.method_47612(new ConfigSliderWidget(hideGridAdder.method_48638().method_46426(), hideGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "hide.block_outline", new Object[]{class_2561.method_43470(PerspectiveConfig.config.blockOutline.value() + "%")}, false), blockOutlineLevel) {
				@Override
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(),  "hide.block_outline.level", new Object[]{class_2561.method_43470(PerspectiveConfig.config.blockOutline.value() + "%")}, false));
				}
				@Override
				protected void method_25344() {
					PerspectiveConfig.config.blockOutline.setValue((int) ((field_22753) * 100), false);
				}
			});
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.rainbow_block_outline", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.rainbowBlockOutline.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.rainbowBlockOutline, false);

			}).build());
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.crosshair", new Object[]{Translation.getCrosshairTranslation(Data.getVersion().getID(), PerspectiveConfig.config.crosshairType.value())}), (button) -> {
				PerspectiveConfig.config.crosshairType.setValue(Hide.nextCrosshairMode(), false);

			}).build());
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.hide_armor", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.hideArmor.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.hideArmor, false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "hide.hide_armor", true))).build());
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.hide_nametags", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.hideNametags.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.hideNametags, false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "hide.hide_nametags", true))).build());
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.hide_players", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.hidePlayers.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.hidePlayers, false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "hide.hide_players", true))).build());
			hideGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hide.show_message", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.hideShowMessage.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.hideShowMessage, false);

			}).build());
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/hide/page1: " + error.getLocalizedMessage());
		}
		return hideGrid;
	}
	public class_437 getRefreshScreen() {
		return new HideConfigScreen(this.parentScreen, this.page);
	}
	public String getPageId() {
		return "hide";
	}
}