/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.hold_perspective;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.screen.widget.ConfigSliderWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class HoldPerspectiveConfigScreen extends AbstractConfigScreen {
	public HoldPerspectiveConfigScreen(class_437 parentScreen, int page) {
		super(parentScreen, page);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createPageOne());
			else shouldClose = true;
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize hold_perspective config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createPageOne() {
		class_7845 holdPerspectiveGrid = new class_7845();
		holdPerspectiveGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 holdPerspectiveGridAdder = holdPerspectiveGrid.method_47610(2);
		try {
			holdPerspectiveGridAdder.method_47612(new ConfigSliderWidget(holdPerspectiveGridAdder.method_48638().method_46426(), holdPerspectiveGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.back.multiplier", new Object[]{String.format("%.2f", PerspectiveConfig.config.holdPerspectiveBackMultiplier.value())}, false), ((PerspectiveConfig.config.holdPerspectiveBackMultiplier.value() - 0.5F) / 15.5F)) {
				@Override
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.back.multiplier", new Object[]{String.format("%.2f", PerspectiveConfig.config.holdPerspectiveBackMultiplier.value())}, false));
				}
				@Override
				protected void method_25344() {
					PerspectiveConfig.config.holdPerspectiveBackMultiplier.setValue(Float.valueOf(String.format("%.2f", ((field_22753 * 15.5F) + 0.5F))), false);
				}
			}).method_47400(class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.back.multiplier", true)));
			holdPerspectiveGridAdder.method_47612(new ConfigSliderWidget(holdPerspectiveGridAdder.method_48638().method_46426(), holdPerspectiveGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.front.multiplier", new Object[]{String.format("%.2f", PerspectiveConfig.config.holdPerspectiveFrontMultiplier.value())}, false), ((PerspectiveConfig.config.holdPerspectiveFrontMultiplier.value() - 0.5F) / 15.5F)) {
				@Override
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.front.multiplier", new Object[]{String.format("%.2f", PerspectiveConfig.config.holdPerspectiveFrontMultiplier.value())}, false));
				}
				@Override
				protected void method_25344() {
					PerspectiveConfig.config.holdPerspectiveFrontMultiplier.setValue(Float.valueOf(String.format("%.2f", ((field_22753 * 15.5F) + 0.5F))), false);
				}
			}).method_47400(class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.front.multiplier", true)));
			holdPerspectiveGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.back.hide_hud", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.holdPerspectiveBackHideHud.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.holdPerspectiveBackHideHud, false);
			}).build());
			holdPerspectiveGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.front.hide_hud", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.holdPerspectiveFrontHideHud.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.holdPerspectiveFrontHideHud, false);
			}).build());
			double holdPerspectiveMultiplierIncrementSize = (double) (PerspectiveConfig.config.holdPerspectiveMultiplierIncrementSize.value() - 1) / 9;
			class_357 holdPerspectiveMultiplierIncrementSizeWidget = new ConfigSliderWidget(holdPerspectiveGridAdder.method_48638().method_46426(), holdPerspectiveGridAdder.method_48638().method_46427(), 304, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.increment_size", new Object[]{class_2561.method_43470(String.valueOf(PerspectiveConfig.config.holdPerspectiveMultiplierIncrementSize.value()))}, false), holdPerspectiveMultiplierIncrementSize) {
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.increment_size", new Object[]{class_2561.method_43470(String.valueOf(PerspectiveConfig.config.holdPerspectiveMultiplierIncrementSize.value()))}, false));
				}
				protected void method_25344() {
					PerspectiveConfig.config.holdPerspectiveMultiplierIncrementSize.setValue((int) ((field_22753) * 9) + 1, false);
				}
			};
			holdPerspectiveMultiplierIncrementSizeWidget.method_47400(class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "hold_perspective.increment_size", true)));
			holdPerspectiveGridAdder.method_47613(holdPerspectiveMultiplierIncrementSizeWidget, 2);
			holdPerspectiveGridAdder.method_47613(new class_7852(20, 20), 2);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/hold_perspective/page1: " + error.getLocalizedMessage());
		}
		return holdPerspectiveGrid;
	}
	public class_437 getRefreshScreen() {
		return new HoldPerspectiveConfigScreen(this.parentScreen, this.page);
	}
	public String getPageId() {
		return "hold_perspective";
	}
}