package com.mclegoman.perspective.client.screen.config.information;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.common.data.Data;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3518;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

public class InfoWidget extends class_350<InfoWidget.InfoEntry> {
    private final class_327 textRenderer;

    public InfoWidget(class_310 client, class_2960 id, int width, int height, int y, int lineHeight) {
        this(client, id, width, height, y, lineHeight, (double)0.0F);
    }

    public InfoWidget(class_310 client, class_2960 id, int width, int height, int y, int lineHeight, double scrollY) {
        super(client, width, height, y, lineHeight);
        this.textRenderer = client.field_1772;

        for(class_5481 row : this.textRenderer.method_1728(load(id, InfoWidget::read), this.method_25322())) {
            this.method_25321(new InfoWidget.InfoEntry(row));
        }

        this.method_44382(scrollY);
    }

    protected void method_44397(class_332 context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
        InfoWidget.InfoEntry entry = this.method_25326(index);
        entry.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.method_37019(), entry), delta);
    }

    public int method_25322() {
        return this.field_22758 - 24;
    }

    protected void method_47399(class_6382 builder) {
    }

    private static class_2561 load(class_2960 id, InfoWidget.InfoReader infoReader) {
        try (Reader reader = ClientData.minecraft.method_1478().openAsReader(id)) {
            return infoReader.read(reader);
        } catch (Exception exception) {
            Data.getVersion().sendToLog(LogType.ERROR, "Couldn't load info from file " + id + ": " + exception.getLocalizedMessage());
            return class_2561.method_43473();
        }
    }

    private static class_2561 read(Reader reader) {
        JsonObject root = class_3518.method_15255(reader).getAsJsonObject();
        class_5250 text = class_2561.method_43473();
        if (root.has("values")) {
            for(JsonElement element : root.getAsJsonArray("values")) {
                text.method_10852(read(class_2561.method_43473(), element));
                if (root.has("line_breaks") && root.get("line_breaks").getAsBoolean()) {
                    text.method_27693("\n");
                }
            }
        }

        return text;
    }

    private static class_2561 read(class_5250 text, JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        if (jsonObject.has("indent")) {
            int indents = jsonObject.get("indent").getAsInt();
            if (indents > 0) {
                text.method_10852(class_2561.method_43470(" ".repeat(indents)));
            }
        }

        List<class_2561> args = new ArrayList();
        if (jsonObject.has("args")) {
            for(JsonElement argElement : jsonObject.getAsJsonArray("args")) {
                args.add(read(class_2561.method_43473(), argElement));
            }
        }

        if (jsonObject.has("value")) {
            class_5250 var10001;
            switch ((jsonObject.has("type") ? InfoWidget.TextType.valueOf(jsonObject.get("type").getAsString()) : InfoWidget.TextType.literal).ordinal()) {
                case 0 -> var10001 = class_2561.method_43470(jsonObject.get("value").getAsString());
                case 1 -> var10001 = class_2561.method_43469(jsonObject.get("value").getAsString(), args.toArray(new Object[0]));
                default -> throw new MatchException((String)null, (Throwable)null);
            }

            text.method_10852(var10001);
        }

        return text;
    }

    public class InfoEntry extends class_350.class_351<InfoWidget.InfoEntry> {
        private final class_5481 text;

        public InfoEntry(class_5481 text) {
            this.text = text;
        }

        public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            context.method_35720(InfoWidget.this.textRenderer, this.text, x, y, -5592406);
        }
    }

    private static enum TextType implements class_3542 {
        literal("literal"),
        translatable("translatable");

        final String id;

        private TextType(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }
    }

    interface InfoReader {
        class_2561 read(Reader var1) throws IOException;
    }
}
