/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.information;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.screen.config.LinkScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7919;

public class InformationScreen extends AbstractConfigScreen {
	public InformationScreen(class_437 parentScreen) {
		super(parentScreen, 1);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createInformation());
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize zoom config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createInformation() {
		class_7845 infoGrid = new class_7845();
		infoGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 infoGridAdder = infoGrid.method_47610(1);
		try {
			class_4185 documentationButton = ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "information.documentation"), button -> ClientData.minecraft.method_1507(new LinkScreen(ClientData.minecraft.field_1755, "https://mclegoman.com/Perspective", true))).width(304).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "information.documentation", true))).build();
			documentationButton.field_22763 = false;
			infoGridAdder.method_47613(documentationButton, 1);
			infoGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "information.source_code"), button -> ClientData.minecraft.method_1507(new LinkScreen(ClientData.minecraft.field_1755, "https://github.com/mclegoman/perspective", true))).width(304).build(), 1);
			infoGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "information.report"), button -> ClientData.minecraft.method_1507(new LinkScreen(ClientData.minecraft.field_1755, "https://github.com/mclegoman/perspective/issues", true))).width(304).build(), 1);
			infoGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "information.credits"), button -> ClientData.minecraft.method_1507(new CreditsAttributionScreen(ClientData.minecraft.field_1755))).width(304).build(), 1);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "error loading info screen: " + error.getLocalizedMessage());
		}
		return infoGrid;
	}
	protected class_7845 createFooter() {
		class_7845 footerGrid = new class_7845();
		footerGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 footerGridAdder = footerGrid.method_47610(this.getMaxPage() > 1 ? 2 : 1);
		try {
			footerGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "back"), (button) -> {
				if (this.page <= 1) {
					this.shouldClose = true;
				} else {
					this.page -= 1;

				}
			}).build());
			if (this.getMaxPage() > 1) {
				class_4185 nextButtonWidget = class_4185.method_46430(Translation.getConfigTranslation(Data.getVersion().getID(), "next"), (button) -> {
					if (!(this.page >= getMaxPage())) {
						this.page += 1;

					}
				}).method_46431();
				if (this.page >= getMaxPage()) nextButtonWidget.field_22763 = false;
				footerGridAdder.method_47612(nextButtonWidget);
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error occurred whilst loading info screen footer: " + error.getLocalizedMessage());
		}
		return footerGrid;
	}
	public String getPageId() {
		return "information";
	}
	public class_437 getRefreshScreen() {
		return new InformationScreen(this.parentScreen);
	}
}