/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.overlays;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.value.QualityToggle;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.hud.Overlays;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.time.GameDate;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class OverlaysConfigScreen extends AbstractConfigScreen {
	public OverlaysConfigScreen(class_437 parentScreen, int page) {
		super(parentScreen, page);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createPageOne());
			else if (this.page == 2) this.gridAdder.method_47612(createPageTwo());
			else shouldClose = true;
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize zoom config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createPageOne() {
		class_7845 overlaysGrid = new class_7845();
		overlaysGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 overlaysGridAdder = overlaysGrid.method_47610(2);
		try {
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.version_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.versionOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.versionOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.position_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.positionOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.positionOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.time_overlay", new Object[]{Translation.getTimeOverlayTranslation(Data.getVersion().getID(), Overlays.getCurrentTimeOverlay())}), (button) -> {
				Overlays.cycleTimeOverlay(!method_25442());
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.day_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.dayOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.dayOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.date_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.dateOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.dateOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> {
				class_2960 typeId = GameDate.getTypeIdFromConfig();
				return Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.date_type", new Object[]{Translation.getTranslation(typeId.method_12836(), "date." + typeId.method_12832())});
			}, (button) -> {
				GameDate.cycle(!method_25442());
			}).tooltip(() -> {
				class_2960 typeId = GameDate.getTypeIdFromConfig();
				return class_7919.method_47407(class_2561.method_48321(Translation.getTranslationKey(typeId.method_12836(), "date." + typeId.method_12832()) + ".description", ""));
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.biome_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.biomeOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.biomeOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.looking_at_overlay", new Object[]{Translation.getQualityTranslation(Data.getVersion().getID(), PerspectiveConfig.config.lookingAtOverlay.value())}), (button) -> {
				PerspectiveConfig.config.lookingAtOverlay.setValue(switch (PerspectiveConfig.config.lookingAtOverlay.value()) {
					case off -> method_25442() ? QualityToggle.fancy : QualityToggle.fast;
					case fast -> method_25442() ? QualityToggle.off : QualityToggle.fancy;
					case fancy -> method_25442() ? QualityToggle.fast : QualityToggle.off;
				}, false);
			}).build());
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "error occurred on overlays screen: " + error.getLocalizedMessage());
		}
		return overlaysGrid;
	}
	private class_7845 createPageTwo() {
		class_7845 overlaysGrid = new class_7845();
		overlaysGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 overlaysGridAdder = overlaysGrid.method_47610(2);
		try {
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.deaths_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.deathsOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.deathsOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.totems_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.totemsOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.totemsOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.cps_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.cpsOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.cpsOverlay, false);
			}).build());
			overlaysGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "overlays.armor_overlay", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.armorOverlay.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.armorOverlay, false);
			}).build());
			overlaysGridAdder.method_47613(new class_7852(20, 20), 2);
			overlaysGridAdder.method_47613(new class_7852(20, 20), 2);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "error occurred on overlays screen: " + error.getLocalizedMessage());
		}
		return overlaysGrid;
	}
	public class_437 getRefreshScreen() {
		return new OverlaysConfigScreen(this.parentScreen, this.page);
	}
	public String getPageId() {
		return "overlays";
	}
	public int getMaxPage() {
		return 2;
	}
}