/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.shaders;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.shaders.ShaderPacks;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.lwjgl.glfw.GLFW;

public class ShaderPackSelectionScreen extends class_437 {
	public final class_437 parent;
	private final class_124[] formatting;
	private ShaderPacksListWidget<?> widget;
	private boolean shouldClose;
	private final double scrollAmount;
	private final boolean blurEnabled;
	public boolean refresh;
	public ShaderPackSelectionScreen(class_437 parent, class_124[] formatting, double scrollAmount, boolean blurEnabled) {
		super(class_2561.method_43470(""));
		this.parent = parent;
		this.formatting = formatting;
		this.scrollAmount = scrollAmount;
		this.blurEnabled = ClientData.minecraft.field_1687 == null || blurEnabled;
		this.refresh = false;
	}
	protected void method_25426() {
		try {
			method_37063(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.mode", new Object[]{Translation.getShaderModeTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsMode.value().name())}), (button) -> {
				ShaderPacks.cycleShaderMode();

			}).tooltip(() -> class_7919.method_47407(Translation.getShaderModeTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsMode.value().name(), true))).dimensions(ClientData.minecraft.method_22683().method_4486() / 2 - 150, ClientData.minecraft.method_22683().method_4502() - 50, 148, 20).build());

			method_37063(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.toggle", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsEnabled.value(), Translation.Type.ENDISABLE)}), (button) -> {
				ShaderPacks.toggle();

			}).dimensions(ClientData.minecraft.method_22683().method_4486() / 2 + 2, ClientData.minecraft.method_22683().method_4502() - 50, 148, 20).build());

			method_37063(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "back"), (button) -> this.shouldClose = true).dimensions(ClientData.minecraft.method_22683().method_4486() / 2 - 75, ClientData.minecraft.method_22683().method_4502() - 26, 150, 20).build());
			if (ClientData.minecraft.field_1687 != null)
				method_37063(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.toggle_blur", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsSelectionBlur.value(), Translation.Type.BLUR)}), (button) -> {
					PerspectiveConfig.toggle(PerspectiveConfig.config.superSecretSettingsSelectionBlur, true);

				}).dimensions(ClientData.minecraft.method_22683().method_4486() - 42, ClientData.minecraft.method_22683().method_4502() - 38, 20, 20).build());

			this.widget = new ShaderPacksListWidget<>(ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 56, 20, this.scrollAmount);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error occurred on shader selection screen: " + error.getLocalizedMessage());
		}
		method_37063(widget);
	}
	public void method_25393() {
		try {
			if (this.shouldClose) {
				ClientData.minecraft.method_1507(parent);
			}
			if (this.refresh) {
				ClientData.minecraft.method_1507(new ShaderPackSelectionScreen(parent, formatting, widget.method_44387(), PerspectiveConfig.config.superSecretSettingsSelectionBlur.value()));
			}
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to tick perspective$config$shaders$select screen: {}", error));
		}
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_25394(context, mouseX, mouseY, delta);
		context.method_27534(ClientData.minecraft.field_1772, Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.list.select", formatting), ClientData.minecraft.method_22683().method_4486() / 2, 12, 0xFFFFFF);
	}
	@Override
	public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
		if (blurEnabled) super.method_25420(context, mouseX, mouseY, delta);
	}
	@Override
	public boolean method_25422() {
		return false;
	}
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (keyCode == GLFW.GLFW_KEY_ESCAPE || keyCode == KeyBindingHelper.getBoundKeyOf(Keybindings.openConfig).method_1444())
			this.shouldClose = true;
		if (keyCode == GLFW.GLFW_KEY_F1) {
			PerspectiveConfig.toggle(PerspectiveConfig.config.superSecretSettingsSelectionBlur, true);
			
		}
		return super.method_25404(keyCode, scanCode, modifiers);
	}
	public boolean method_25421() {
		return false;
	}
}