/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.shaders;

import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.shaders.ShaderPacks;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5481;
import net.minecraft.class_8002;
import net.minecraft.class_9110;

public class ShaderPacksListWidget<E extends ShaderListEntry<E>> extends class_4280<E> {
	protected ShaderPacksListWidget(int width, int height, int top, int bottom, int itemHeight, double scrollAmount) {
		super(ClientData.minecraft, width, height - top - bottom, top, itemHeight);
		ShaderPacks.getRegistryIds().forEach((id) -> this.addEntry((E) new ShaderListEntry<E>(id)));
		if (this.method_25340() > 0) {
			int index = ShaderPacks.getRegistryIds().indexOf(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier());
			if (index >= 0) {
				super.method_25313(method_25326(index));
				this.method_44382(scrollAmount >= 0 ? scrollAmount : index * 20);
			}
		}
		this.method_25365(true);
	}
	@Override
	public void setSelected(@Nullable E entry) {
		super.method_25313(entry);
		if (entry != null && PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier() != entry.id) ShaderPacks.setShader(entry.id);
	}
	@Override
	protected int addEntry(E entry) {
		return super.method_25321(entry);
	}
	@Override
	protected int method_65507()  {
		return (ClientData.minecraft.method_22683().method_4486()) - 6;
	}
	@Override
	public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_48579(context, mouseX, mouseY, delta);
		if (ClientData.minecraft.field_1755 != null && getEntryTooltip().method_56137() != null) {
			List<class_5481> lines = getEntryTooltip().method_56137().method_47405(ClientData.minecraft);
			int width = 0;
			for (class_5481 text : lines) {
				int textWidth = ClientData.minecraft.field_1772.method_30880(text);
				if (textWidth > width) width = textWidth;
			}
			int x = (mouseX + width > (ClientData.minecraft.field_1755.field_22789 - 32)) ? mouseX - width : mouseX;
			class_8002.method_47946(context, x + 1, mouseY + 10, width + 4, (lines.size() * 10) + 4, 300, null);
			context.method_51448().method_46416(0.0F, 0.0F, 400.0F);
			for (int i = 0; i < lines.size(); i++) context.method_35720(ClientData.minecraft.field_1772, lines.get(i), x + 2, mouseY + 12 + (i * 10), 0xFFFFFF);
		}
	}
	@Override
	protected void method_44397(class_332 context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
		E entry = this.method_25326(index);
		entry.method_49568(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.method_37019(), entry), delta);
		if (this.method_25332(index)) this.method_44398(context, y, entryWidth, entryHeight, -1, -16777216);
		else if (Objects.equals(method_25326(index), method_37019())) this.method_44398(context, y, entryWidth, entryHeight, -8355712, -16777216);
		entry.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.method_37019(), entry), delta);
	}
	private class_9110 getEntryTooltip() {
		class_9110 entryTooltip = new class_9110();
		if (method_37019() != null) entryTooltip.method_56138(ShaderPacks.getTooltip(method_37019().id));
		return entryTooltip;
	}
}