/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.shaders;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.logo.PerspectiveLogo;
import com.mclegoman.perspective.client.logo.SplashesDataloader;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.shaders.ShaderPacks;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.ui.UIBackground;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_124;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7919;

public class ShadersConfigScreen extends AbstractConfigScreen {
	public ShadersConfigScreen(class_437 parentScreen) {
		super(parentScreen, 1);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) {
				this.gridAdder.method_47612(createPageOne());
			}
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize shaders config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createPageOne() {
		class_7845 shaderOptionsGrid = new class_7845();
		shaderOptionsGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 shaderOptionsGridAdder = shaderOptionsGrid.method_47610(2);
		try {
			shaderOptionsGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings", new class_124[]{ShaderPacks.getRandomColor()}), (button) -> ClientData.minecraft.method_1507(new SuperSecretSettingsConfigScreen(getRefreshScreen(), new class_124[]{ShaderPacks.getRandomColor()}))).width(304).build(), 2);
			shaderOptionsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.kaleidoscope.random", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.randomKaleidoscope.value(), Translation.Type.ONFF)}), (button) -> PerspectiveConfig.toggle(PerspectiveConfig.config.randomKaleidoscope)).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.kaleidoscope.random", true))).build());
			shaderOptionsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.kaleidoscope.named", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.namedKaleidoscope.value(), Translation.Type.ONFF)}), (button) -> PerspectiveConfig.toggle(PerspectiveConfig.config.namedKaleidoscope)).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.kaleidoscope.named", true))).build());
			shaderOptionsGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.ui_background", new Object[]{Translation.getUIBackgroundTranslation(Data.getVersion().getID(), UIBackground.getCurrentUIBackground().getId())}), (button) -> UIBackground.cycleUIBackgroundType(!method_25442())).tooltip(() -> class_7919.method_47407(Translation.getUIBackgroundTranslation(Data.getVersion().getID(), UIBackground.getCurrentUIBackground().getId(), true))).width(304).build(), 2);
			shaderOptionsGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "luminance"), (button) -> ClientData.minecraft.method_1507(new com.mclegoman.luminance.client.gui.screen.config.ConfigScreen(getRefreshScreen(), 0, SplashesDataloader.getSplashText(), PerspectiveLogo.isPride()))).width(304).build(), 2);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "An error occurred on config/shaders/page1: " + error.getLocalizedMessage());
		}
		return shaderOptionsGrid;
	}
	public class_437 getRefreshScreen() {
		return new ShadersConfigScreen(parentScreen);
	}
	public String getPageId() {
		return "shaders";
	}
}