/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.shaders;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.shaders.ShaderPacks;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_124;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;

public class SuperSecretSettingsConfigScreen extends AbstractConfigScreen {
	private class_124[] formatting;
	public SuperSecretSettingsConfigScreen(class_437 parentScreen, class_124[] formatting) {
		super(parentScreen, 1);
		this.formatting = formatting;
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) {
				this.gridAdder.method_47612(createShaders());
				this.gridAdder.method_47612(createPageOne());
				this.gridAdder.method_47612(new class_7852(16, 16));
			}
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize super secret settings config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createShaders() {
		class_7845 shadersGrid = new class_7845();
		shadersGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 shadersGridAdder = shadersGrid.method_47610(2);
		try {
			ConfigButtonWidget cycleShaders = ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.cycle", new Object[]{ShaderPacks.getShader() != null ? ShaderPacks.getShader().translation().getTranslation(ShaderPacks.shouldShowNamespace(ShaderPacks.getShadersId(), ShaderPacks.getShader().translation().id())) : Translation.getShaderTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.not_loaded")}), (button) -> {
				ShaderPacks.cycle(!method_25442());
				this.formatting = new class_124[]{ShaderPacks.getRandomColor()};

			}).tooltip(ShaderPacks::getTooltip).width(280).build();
			cycleShaders.field_22763 = ShaderPacks.isShadersEnabled();
			shadersGridAdder.method_47612(cycleShaders);
			ConfigButtonWidget listShaders = ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.list"), (button) -> ClientData.minecraft.method_1507(new ShaderPackSelectionScreen(getRefreshScreen(), new class_124[]{ShaderPacks.getRandomColor()}, -1, PerspectiveConfig.config.superSecretSettingsSelectionBlur.value()))).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.list", true))).width(20).build();
			listShaders.field_22763 = ShaderPacks.isShadersEnabled();
			shadersGridAdder.method_47612(listShaders);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "error creating shaders on super secret settings screen: " + error.getLocalizedMessage());
		}
		return shadersGrid;
	}
	private class_7845 createPageOne() {
		class_7845 shaderOptionsGrid = new class_7845();
		shaderOptionsGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 shaderOptionsGridAdder = shaderOptionsGrid.method_47610(2);
		try {
			shaderOptionsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.mode", new Object[]{Translation.getShaderModeTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsMode.value().name())}), (button) -> {
				ShaderPacks.cycleShaderMode();

			}).tooltip(() -> class_7919.method_47407(Translation.getShaderModeTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsMode.value().name(), true))).build());
			ConfigButtonWidget randomShader = ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.random"), (button) -> {
				ShaderPacks.randomize();
			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.random", true))).build();
			randomShader.field_22763 = ShaderPacks.isShadersEnabled();
			shaderOptionsGridAdder.method_47612(randomShader);
			shaderOptionsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.show_name", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsShowName.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.superSecretSettingsShowName, false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.show_name", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.show_name." + (PerspectiveConfig.config.superSecretSettingsShowName.value() ? "on" : "off"), true)}, true))).build());
			shaderOptionsGridAdder.method_47612(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "shaders.super_secret_settings.toggle", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsEnabled.value(), Translation.Type.ENDISABLE)}), (button) -> {
				ShaderPacks.toggle();

			}).build());
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "error on super secret settings screen: " + error.getLocalizedMessage());
		}
		return shaderOptionsGrid;
	}
	public class_437 getRefreshScreen() {
		return new SuperSecretSettingsConfigScreen(parentScreen, formatting);
	}
	public String getPageId() {
		return "shaders.super_secret_settings";
	}
}