/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.textured_entity;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import com.mclegoman.perspective.client.config.PerspectiveConfig;

public class TexturedEntityConfigScreen extends AbstractConfigScreen {
	public TexturedEntityConfigScreen(class_437 parentScreen) {
		super(parentScreen, 1);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) {
				this.gridAdder.method_47612(createTexturedEntity());
			}
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize textured entity config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createTexturedEntity() {
		class_7845 texturedEntityGrid = new class_7845();
		texturedEntityGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 texturedEntityGridAdder = texturedEntityGrid.method_47610(1);
		try {
			texturedEntityGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "textured_entity.named", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.texturedNamedEntity.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.texturedNamedEntity, false);

			}).width(304).build(), 1);
			texturedEntityGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "textured_entity.random", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.texturedRandomEntity.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.texturedRandomEntity, false);

			}).width(304).build(), 1);
			texturedEntityGridAdder.method_47612(new class_7852(20, 20));
			texturedEntityGridAdder.method_47612(new class_7852(20, 20));
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "An error occurred whilst creating textured entity screen: " + error.getLocalizedMessage());
		}
		return texturedEntityGrid;
	}
	public class_437 getRefreshScreen() {
		return new TexturedEntityConfigScreen(this.parentScreen);
	}
	public String getPageId() {
		return "textured_entity";
	}
	public boolean isBeingReworked() {
		return true;
	}
}