/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.config.zoom;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.hide.Hide;
import com.mclegoman.perspective.client.screen.config.AbstractConfigScreen;
import com.mclegoman.perspective.client.screen.widget.ConfigButtonWidget;
import com.mclegoman.perspective.client.screen.widget.ConfigSliderWidget;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.zoom.Zoom;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.client.gui.widget.*;

public class ZoomConfigScreen extends AbstractConfigScreen {
	public ZoomConfigScreen(class_437 parentScreen, int page) {
		super(parentScreen, page);
	}
	public void method_25426() {
		try {
			super.method_25426();
			if (this.page == 1) this.gridAdder.method_47612(createPageOne());
			else if (this.page == 2) this.gridAdder.method_47612(createPageTwo());
			else shouldClose = true;
			postInit();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize zoom config screen: {}", error));
			ClientData.minecraft.method_1507(this.parentScreen);
		}
	}
	private class_7845 createPageOne() {
		class_7845 zoomGrid = new class_7845();
		zoomGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 zoomGridAdder = zoomGrid.method_47610(2);
		try {
			double zoomLevel = (double) PerspectiveConfig.config.zoomLevel.value() / 100;
			zoomGridAdder.method_47613(new ConfigSliderWidget(zoomGridAdder.method_48638().method_46426(), zoomGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.level", new Object[]{class_2561.method_43470(PerspectiveConfig.config.zoomLevel.value() + "%")}, false), zoomLevel) {
				@Override
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.level", new Object[]{class_2561.method_43470(PerspectiveConfig.config.zoomLevel.value() + "%")}, false));
				}

				@Override
				protected void method_25344() {
					PerspectiveConfig.config.zoomLevel.setValue((int) ((field_22753) * 100), false);
				}
			}, 1);
			double zoomIncrementSize = (double) (PerspectiveConfig.config.zoomIncrementSize.value() - 1) / 9;
			class_357 zoomIncrementSizeWidget = new ConfigSliderWidget(zoomGridAdder.method_48638().method_46426(), zoomGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.increment_size", new Object[]{class_2561.method_43470(String.valueOf(PerspectiveConfig.config.zoomIncrementSize.value()))}, false), zoomIncrementSize) {
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.increment_size", new Object[]{class_2561.method_43470(String.valueOf(PerspectiveConfig.config.zoomIncrementSize.value()))}, false));
				}

				protected void method_25344() {
					PerspectiveConfig.config.zoomIncrementSize.setValue((int) ((field_22753) * 9) + 1, false);
				}
			};
			zoomIncrementSizeWidget.method_47400(class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.increment_size", true)));
			zoomGridAdder.method_47613(zoomIncrementSizeWidget, 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.type", new Object[]{Translation.getZoomTypeTranslation(Zoom.getZoomType().method_12836(), Zoom.getZoomType().method_12832())}), (button) -> {
				Zoom.cycleZoomType(!method_25442());
			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.type", new Object[]{Translation.getZoomTypeTranslation(Zoom.getZoomType().method_12836(), Zoom.getZoomType().method_12832(), true)}, true))).build(), 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.transition", new Object[]{Translation.getZoomTransitionTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomTransition.value())}), (button) -> {
				PerspectiveConfig.config.zoomTransition.setValue(Zoom.nextTransition(), false);
			}).build(), 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.scale_mode", new Object[]{Translation.getZoomScaleModeTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomScaleMode.value())}), (button) -> {
				PerspectiveConfig.config.zoomScaleMode.setValue(Zoom.nextScaleMode(), false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.scale_mode", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.scale_mode." + PerspectiveConfig.config.zoomScaleMode.value(), true)}, true))).build(), 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.reset", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomReset.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.zoomReset, false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.reset", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.reset." + PerspectiveConfig.config.zoomReset.value(), true)}, true))).build(), 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.cinematic", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomCinematic.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.zoomCinematic, false);

			}).build(), 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.enabled", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomEnabled.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.zoomEnabled, false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.enabled", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.enabled." + PerspectiveConfig.config.zoomEnabled.value(), true)}, true))).build(), 1);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/zoom/page1: " + error.getLocalizedMessage());
		}
		return zoomGrid;
	}
	private class_7845 createPageTwo() {
		class_7845 zoomGrid = new class_7845();
		zoomGrid.method_46458().method_46467().method_46464(2);
		class_7845.class_7939 zoomGridAdder = zoomGrid.method_47610(2);
		try {
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.hide_hud", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.hide_hud." + PerspectiveConfig.config.zoomHideHud.value())}), (button) -> {
				PerspectiveConfig.config.zoomHideHud.setValue(Hide.nextZoomHideHudMode(), false);

			}).tooltip(() -> class_7919.method_47407(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.hide_hud", new Object[]{Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.hide_hud." + PerspectiveConfig.config.zoomHideHud.value(), true)}, true))).build(), 1);
			zoomGridAdder.method_47613(ConfigButtonWidget.builder(() -> Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.show_percentage", new Object[]{Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomShowPercentage.value(), Translation.Type.ONFF)}), (button) -> {
				PerspectiveConfig.toggle(PerspectiveConfig.config.zoomShowPercentage, false);

			}).build(), 1);
			zoomGridAdder.method_47612(new ConfigSliderWidget(zoomGridAdder.method_48638().method_46426(), zoomGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.smooth_speed_in", new Object[]{Translation.getZoomSmoothSpeedTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomSmoothSpeedIn.value())}, false), (PerspectiveConfig.config.zoomSmoothSpeedIn.value() - 0.01F) / 1.99F) {
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.smooth_speed_in", new Object[]{Translation.getZoomSmoothSpeedTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomSmoothSpeedIn.value())}, false));
				}
				protected void method_25344() {
					PerspectiveConfig.config.zoomSmoothSpeedIn.setValue(Float.valueOf(String.format("%.2f", ((field_22753) * 1.99F) + 0.01F)), false);
				}
			});
			zoomGridAdder.method_47612(new ConfigSliderWidget(zoomGridAdder.method_48638().method_46426(), zoomGridAdder.method_48638().method_46427(), 150, 20, Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.smooth_speed_out", new Object[]{Translation.getZoomSmoothSpeedTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomSmoothSpeedOut.value())}, false), (PerspectiveConfig.config.zoomSmoothSpeedOut.value() - 0.01F) / 1.99F) {
				protected void method_25346() {
					method_25355(Translation.getConfigTranslation(Data.getVersion().getID(), "zoom.smooth_speed_out", new Object[]{Translation.getZoomSmoothSpeedTranslation(Data.getVersion().getID(), PerspectiveConfig.config.zoomSmoothSpeedOut.value())}, false));
				}
				protected void method_25344() {
					PerspectiveConfig.config.zoomSmoothSpeedOut.setValue(Float.valueOf(String.format("%.2f", ((field_22753) * 1.99F) + 0.01F)), false);
				}
			});
			zoomGridAdder.method_47613(new class_7852(20, 20), 2);
			zoomGridAdder.method_47613(new class_7852(20, 20), 2);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error creating config/zoom/page2: " + error.getLocalizedMessage());
		}
		return zoomGrid;
	}
	public class_437 getRefreshScreen() {
		return new ZoomConfigScreen(this.parentScreen, this.page);
	}
	public String getPageId() {
		return "zoom";
	}
	public int getMaxPage() {
		return 2;
	}
}