/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.widget;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.common.data.Data;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.Callable;

public class ConfigButtonWidget extends class_4185 {
	private final Callable<class_2561> callableMessage;
	private final Callable<class_7919> callableTooltip;
	protected ConfigButtonWidget(int x, int y, int width, int height, Callable<class_2561> message, class_4241 onPress, class_7841 narrationSupplier, Callable<class_7919> tooltip) throws Exception {
		super(x, y, width, height, message.call(), onPress, narrationSupplier);
		callableMessage = message;
		callableTooltip = tooltip;
		updateTooltip();
	}
	private void updateTooltip() {
		try {
			this.method_47400(this.callableTooltip != null ? this.callableTooltip.call() : null);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, "Error updating tooltip: " + error.getLocalizedMessage());
		}
	}
	@Override
	public void method_25306() {
		super.method_25306();
		try {
			this.method_25355(callableMessage.call());
			updateTooltip();
		} catch (Exception ignored) {
		}
	}
	public static Builder builder(Callable<class_2561> message, class_4241 onPress) {
		return new Builder(message, onPress);
	}
	@Environment(EnvType.CLIENT)
	public static class Builder {
		private final Callable<class_2561> message;
		private final class_4241 onPress;
		@Nullable
		private Callable<class_7919> tooltip;
		private int x;
		private int y;
		private int width = 150;
		private int height = 20;
		private class_7841 narrationSupplier;

		public Builder(Callable<class_2561> message, class_4241 onPress) {
			this.narrationSupplier = field_40754;
			this.message = message;
			this.onPress = onPress;
		}

		public Builder position(int x, int y) {
			this.x = x;
			this.y = y;
			return this;
		}

		public Builder width(int width) {
			this.width = width;
			return this;
		}

		public Builder size(int width, int height) {
			this.width = width;
			this.height = height;
			return this;
		}

		public Builder dimensions(int x, int y, int width, int height) {
			return this.position(x, y).size(width, height);
		}

		public Builder tooltip(@Nullable Callable<class_7919> tooltip) {
			this.tooltip = tooltip;
			return this;
		}

		public Builder narrationSupplier(class_7841 narrationSupplier) {
			this.narrationSupplier = narrationSupplier;
			return this;
		}

		public ConfigButtonWidget build() throws Exception {
			return new ConfigButtonWidget(this.x, this.y, this.width, this.height, this.message, this.onPress, this.narrationSupplier, this.tooltip);
		}
	}
}
