/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.screen.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.Callable;

public class LogoButtonWidget extends class_4185 {
	private final Callable<class_2960> texture;
	protected LogoButtonWidget(int x, int y, int width, int height, class_2561 message, class_4241 onPress, class_7841 narrationSupplier, Callable<class_2960> texture) {
		super(x, y, width, height, message, onPress, narrationSupplier);
		this.texture = texture;
	}
	public static Builder create(Callable<class_2960> texture, class_4241 onPress) {
		return new Builder(texture, onPress);
	}
	@Environment(EnvType.CLIENT)
	public static class Builder {
		private final Callable<class_2960> texture;
		private final class_2561 message;
		private final class_4241 onPress;
		@Nullable
		private class_7919 tooltip;
		private int x;
		private int y;
		private int width = 150;
		private int height = 20;
		private class_7841 narrationSupplier;

		public Builder(Callable<class_2960> texture, class_4241 onPress) {
			this.narrationSupplier = class_4185.field_40754;
			this.message = class_2561.method_30163("");
			this.texture = texture;
			this.onPress = onPress;
		}

		public LogoButtonWidget.Builder position(int x, int y) {
			this.x = x;
			this.y = y;
			return this;
		}

		public LogoButtonWidget.Builder width(int width) {
			this.width = width;
			return this;
		}

		public LogoButtonWidget.Builder size(int width, int height) {
			this.width = width;
			this.height = height;
			return this;
		}

		public LogoButtonWidget.Builder dimensions(int x, int y, int width, int height) {
			return this.position(x, y).size(width, height);
		}

		public LogoButtonWidget.Builder tooltip(@Nullable class_7919 tooltip) {
			this.tooltip = tooltip;
			return this;
		}

		public LogoButtonWidget.Builder narrationSupplier(class_7841 narrationSupplier) {
			this.narrationSupplier = narrationSupplier;
			return this;
		}

		public LogoButtonWidget build() {
			LogoButtonWidget buttonWidget = new LogoButtonWidget(this.x, this.y, this.width, this.height, this.message, this.onPress, this.narrationSupplier, this.texture);
			buttonWidget.method_47400(this.tooltip);
			return buttonWidget;
		}
	}
	protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_48579(context, mouseX, mouseY, delta);
		try {
			class_2960 texture = this.texture.call();
			if (texture != null) {
				int i = this.field_22763 ? class_9848.method_61317(this.field_22765) : 10526880;
				context.method_25291(class_1921::method_62277, texture, this.method_46426() + 1, this.method_46427() + 1, 0.0F, 0.0F, this.method_25368() - 2, this.method_25364() - 2, this.method_25368() - 2, this.method_25364() - 2, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
			}
		} catch (Exception ignored) {
		}
	}
}
