/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.shaders;

import com.mclegoman.luminance.client.shaders.Shader;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.events.PerspectiveEvents;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.common.util.Identifiers;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

public class Kaleidoscope {
	private static class_2960 shaderPack;
	public static void init() {
		PerspectiveEvents.AfterClientResourceReload.register(getId(), Kaleidoscope::apply);
		PerspectiveEvents.OnStartItemUse.register(getId(), (stack, world, player, hand) -> {
			if (stack.method_31574(class_1802.field_27070)) apply(stack);
		});
	}
	protected static void apply() {
		apply(class_1799.field_8037);
	}
	protected static void apply(class_1799 stack) {
		PerspectiveEvents.ShaderRender.register(getId(), new ArrayList<>());
		PerspectiveEvents.ShaderRender.modify(getId(), ShaderPacks.getShaders(() -> {
			try {
				Callable<class_2960> id = getShader(stack);
				return id != null ? ShaderPacks.getShaderPack(id.call()) : null;
			} catch (Exception error) {
				Data.getVersion().sendToLog(LogType.ERROR, "Error getting kaleidoscope shader pack!");
			}
			return null;
		}, Kaleidoscope::getRenderType, Kaleidoscope::getEnabled));
	}
	public static class_2960 getShaderPack(class_1799 stack) {
		shaderPack = stack.method_65130() != null ? set(guessPackId(stack.method_65130().getString()).orElse(set(shaderPack, true)), false) : set(shaderPack, true);
		return shaderPack;
	}
	public static Shader.RenderType getRenderType() {
		return Shader.RenderType.WORLD;
	}
	public static boolean getEnabled() {
		return shouldBeEnabled(false) && shaderPack != null;
	}
	public static boolean shouldBeEnabled(boolean firstPerson) {
		return (getEnabledNamed() || getEnabledRandom()) && (ClientData.minecraft.field_1724 != null && isUsingSpyglass(ClientData.minecraft.field_1724, firstPerson));
	}
	public static boolean getEnabledRandom() {
		return PerspectiveConfig.config.randomKaleidoscope.value();
	}
	public static boolean getEnabledNamed() {
		return PerspectiveConfig.config.namedKaleidoscope.value();
	}
	public static boolean isUsingSpyglass(class_1657 player, boolean firstPerson) {
		return player.method_31550() && (ClientData.minecraft.field_1690.method_31044().method_31034() || firstPerson);
	}
	public static class_2960 getId() {
		return Identifiers.KALEIDOSCOPE;
	}
	public static Optional<class_2960> guessPackId(@NotNull String id) {
		return ShaderPacks.guessPackId(id.toLowerCase().replace(" ", "_"));
	}
	private static class_2960 set(class_2960 shaderPack, boolean randomize) {
		return (!randomize && getEnabledNamed()) ? shaderPack : (getEnabledRandom() ? ShaderPacks.randomize(shaderPack) : null);
	}
	private static Callable<class_2960> getShader(class_1799 stack) {
		return shouldBeEnabled(true) ? () -> getShaderPack(stack) : null;
	}
}
