/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.shaders;

import com.google.gson.JsonObject;
import com.mclegoman.luminance.client.shaders.Shaders;
import com.mclegoman.perspective.common.data.Data;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public record ShaderPackEntry(class_2960 registry, Translation translation, List<Shader> shaders, JsonObject customData) {
	public ShaderPackEntry(Translation translation, List<Shader> shaders, JsonObject customData) {
		this(ShaderPacks.getShadersId(), translation, shaders, customData);
	}
	public record Translation(class_2960 id, boolean isShaderPack) {
		public Translation(class_2960 id) {
			this(id, true);
		}
		public class_2561 getTranslation(boolean description, boolean shouldShowNamespace) {
			return (isShaderPack ? class_2561.method_48321(Data.getVersion().getID() + ".shader_pack." + id.method_12836() + "." + id.method_12832() + (description ? ".description" : ""), description ? "" : com.mclegoman.perspective.client.translation.Translation.getString((shouldShowNamespace ? id().method_12836() + ":" : "") + id().method_12832())) : com.mclegoman.perspective.client.translation.Translation.getShaderText(id(), shouldShowNamespace, description));
		}
		public class_2561 getTranslation(boolean shouldShowNamespace) {
			return getTranslation(false, shouldShowNamespace);
		}
		public class_2561 getDescription(boolean shouldShowNamespace) {
			return getTranslation(true, shouldShowNamespace);
		}
	}
	public record Shader(class_2960 registry, class_2960 luminance, List<Uniform> uniforms) {
	}
	public record Uniform(class_2960 postEffect, String id, List<Float> values, List<String> overrides) {
	}
}
