/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.shaders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import com.mclegoman.luminance.client.shaders.Shader;
import com.mclegoman.luminance.client.shaders.ShaderRegistryEntry;
import com.mclegoman.luminance.client.shaders.Shaders;
import com.mclegoman.luminance.client.shaders.Uniforms;
import com.mclegoman.luminance.client.util.MessageOverlay;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.config.value.ConfigIdentifier;
import com.mclegoman.perspective.client.config.value.ShaderRenderType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.events.PerspectiveEvents;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import com.mclegoman.perspective.client.screen.config.shaders.ShaderPackSelectionScreen;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.client.zoom.Zoom;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.common.util.Identifiers;
import org.jetbrains.annotations.NotNull;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.Callable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7919;

public class ShaderPacks {
	private static final Random random;
	private static final Map<class_2960, Map<class_2960, ShaderPackEntry>> registries;
	private static class_124 prevColor;
	private static final class_124[] colors;
	public static void init() {
		initUniforms();
		PerspectiveEvents.AfterShaderDataRegistered.register(getShadersId(), ShaderPacks::reload);
		PerspectiveEvents.AfterClientResourceReload.register(getShadersId(), ShaderPacks::applyShader);
		Kaleidoscope.init();
	}
	public static void tick() {
		if (Keybindings.cycleShaders.method_1436()) {
			cycle(!ClientData.minecraft.field_1690.field_1832.method_1434());
			if (PerspectiveConfig.config.superSecretSettingsShowName.value()) {
				ShaderPackEntry pack = getShader();
				if (pack != null) MessageOverlay.setOverlay(class_2561.method_43469("gui.perspective.message.shader", pack.translation().getTranslation(shouldShowNamespace(getShadersId(), pack.translation().id()))).method_27692(getRandomColor()));
			}
		}
		if (Keybindings.toggleShaders.method_1436()) {
			toggle();
			if (PerspectiveConfig.config.superSecretSettingsShowName.value()) MessageOverlay.setOverlay(class_2561.method_43469("gui.perspective.message.shader", Translation.getVariableTranslation(Data.getVersion().getID(), PerspectiveConfig.config.superSecretSettingsEnabled.value(), Translation.Type.ENDISABLE)).method_27692(getRandomColor()));
		}
	}
	public static boolean shouldShowNamespace(class_2960 registryId, class_2960 shaderId) {
		List<String> shaderNames = new ArrayList<>();
		for (class_2960 shader : getRegistry(registryId).keySet()) if (shaderId.method_12832().equals(shader.method_12832())) shaderNames.add(shaderId.method_12832());
		return shaderNames.size() > 1;
	}
	public static Map<class_2960, ShaderPackEntry> getRegistry() {
		return getRegistry(getShadersId());
	}
	public static Map<class_2960, ShaderPackEntry> getRegistry(class_2960 registryId) {
		if (!registries.containsKey(registryId)) registries.put(registryId, new HashMap<>());
		return registries.get(registryId);
	}
	private static void removeFromRegistry(class_2960 identifier) {
		Data.getVersion().sendToLog(LogType.INFO, "Removing '" + identifier.toString() + "' from Super Secret Settings registry!");
		registries.remove(identifier);
	}
	public static List<class_2960> getRegistryIds(class_2960 registryId) {
		return getRegistry(registryId).keySet().stream().sorted().toList();
	}
	public static List<class_2960> getRegistryIds() {
		return getRegistryIds(getShadersId());
	}
	public static void addToRegistry(class_2960 shaderId, ShaderPackEntry.Translation translation, List<ShaderPackEntry.Shader> shaders, JsonObject customData) {
		addToRegistry(getShadersId(), shaderId, translation, shaders, customData);
	}
	public static void addToRegistry(class_2960 registryId, class_2960 shaderId, ShaderPackEntry.Translation translation, List<ShaderPackEntry.Shader> shaders, JsonObject customData) {
		getRegistry(registryId).put(shaderId, new ShaderPackEntry(shaderId, translation, shaders, customData));
	}
	public static void resetRegistry() {
		registries.clear();
	}
	private static void addDefaultShaderPacks() {
		for (ShaderRegistryEntry shader : Shaders.getRegistry()) addToRegistry(shader.getID(), new ShaderPackEntry.Translation(shader.getID(), false), List.of(new ShaderPackEntry.Shader(Shaders.getMainRegistryId(), shader.getID(), new ArrayList<>())), new JsonObject());
	}
	private static void initUniforms() {
		try {
			String path = Data.getVersion().getID();
			Uniforms.registerSingleTree(path, "zoomMultiplier", (tickDelta) -> Zoom.getMultiplier(), null, null);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to initialize uniforms: {}", error));
		}
	}
	public static ShaderPackEntry getShader() {
		return getRegistry().get(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier());
	}
	public static void setShader(class_2960 id) {
		setShader(id, true);
	}
	public static void setShader(class_2960 id, boolean applyShader) {
		PerspectiveConfig.config.superSecretSettingsShader.setValue(ConfigIdentifier.of(id), true);
		if (applyShader) applyShader();
		PerspectiveConfig.config.superSecretSettingsEnabled.setValue(true, true);
		if (ClientData.minecraft.field_1755 instanceof ShaderPackSelectionScreen) {
			((ShaderPackSelectionScreen)ClientData.minecraft.field_1755).refresh = true;
		}
	}
	protected static void applyShader() {
		PerspectiveEvents.ShaderRender.register(getShadersId(), new ArrayList<>());
		PerspectiveEvents.ShaderRender.modify(getShadersId(), getShadersFromId());
	}
	private static List<Shader.Data> getShadersFromId() {
		return ShaderPacks.getShadersFromId(() -> PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier(), () -> PerspectiveConfig.config.superSecretSettingsMode.value().getRenderType(), () -> PerspectiveConfig.config.superSecretSettingsEnabled.value() != Keybindings.holdShaders.method_1434());
	}
	public static List<Shader.Data> getShadersFromId(Callable<class_2960> shaderId, Callable<Shader.RenderType> renderType, Callable<Boolean> enabled) {
		List<Shader.Data> shaders = new ArrayList<>();
		try {
			if (shaderId != null) return getShaders(() -> getShaderPack(shaderId.call()), renderType, enabled);
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, error.getLocalizedMessage());
		}
		return shaders;
	}
	public static List<Shader.Data> getShaders(Callable<ShaderPackEntry> callablePack, Callable<Shader.RenderType> renderType, Callable<Boolean> enabled) {
		List<Shader.Data> shaders = new ArrayList<>();
		try {
			if (callablePack != null) {
				int i = 0;
				ShaderPackEntry shaderPack = callablePack.call();
				if (shaderPack != null) {
					for (ShaderPackEntry.Shader shader : shaderPack.shaders()) {
						shaders.add(new Shader.Data(getShadersId(String.valueOf(i++)), new Shader(Shaders.get(shader.registry(), shader.luminance()), renderType, enabled)));
					}
				}
			} else Data.getVersion().sendToLog(LogType.WARN, "Could not locate the current shader pack!");
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, error.getLocalizedMessage());
		}
		return shaders;
	}
	public static ShaderPackEntry getShaderPack(class_2960 registryId, class_2960 id) {
		return getRegistry(registryId).get(id);
	}
	public static ShaderPackEntry getShaderPack(class_2960 id) {
		return getShaderPack(getShadersId(), id);
	}
	public static Optional<JsonObject> getCustom(String namespace) {
		return getCustom(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier(), namespace);
	}
	public static Optional<JsonObject> getCustom(class_2960 id, String namespace) {
		ShaderPackEntry pack = getShaderPack(id);
		if (pack != null) {
			JsonObject customData = pack.customData();
			if (customData != null && customData.has(namespace)) return Optional.of(class_3518.method_15296(customData, namespace));
		}
		return Optional.empty();
	}
	public static class_124 getRandomColor() {
		return getRandomColor(List.of(class_124.field_1058, class_124.field_1077, class_124.field_1062, class_124.field_1079, class_124.field_1064, class_124.field_1063));
	}
	public static class_124 getRandomColor(List<class_124> forbiddenFormatting) {
		List<class_124> formatting = new ArrayList<>();
		for (class_124 color : colors) if (!forbiddenFormatting.contains(color) && color != prevColor) formatting.add(color);
		class_124 color = formatting.get(random.nextInt(formatting.size()));
		prevColor = color;
		return color;
	}
	public static void cycleShaderMode() {
		switch (PerspectiveConfig.config.superSecretSettingsMode.value()) {
			case ShaderRenderType.ui -> PerspectiveConfig.config.superSecretSettingsMode.setValue(ShaderRenderType.game, true);
			case ShaderRenderType.game -> PerspectiveConfig.config.superSecretSettingsMode.setValue(ShaderRenderType.ui, true);
		}
	}
	public static class_2960 getShadersId() {
		return Identifiers.MAIN;
	}
	public static class_2960 getShadersId(String string) {
		return getShadersId().method_45136(getShadersId().method_12832() + "_" + string);
	}
	public static int getShaderAmount() {
		return getRegistry().size();
	}
	public static boolean isShadersEnabled() {
		return getShaderAmount() > 0;
	}
	public static void randomize() {
		if (isShadersEnabled()) setShader(randomize(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier()));
	}
	public static class_2960 randomize(class_2960 current) {
		class_2960 shaderId = current;
		while (shaderId == current) shaderId = getRegistryIds().get(random.nextInt(getRegistryIds().size()));
		return shaderId;
	}
	public static void cycle(boolean forwards) {
		if (isShadersEnabled()) setShader(getRegistryIds().get(forwards ? (getRegistryIds().indexOf(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier()) + 1) % getRegistryIds().size() : (getRegistryIds().indexOf(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier()) - 1 + getRegistryIds().size()) % getRegistryIds().size()));
	}
	public static void toggle() {
		PerspectiveConfig.config.superSecretSettingsEnabled.setValue(!PerspectiveConfig.config.superSecretSettingsEnabled.value(), true);
	}
	protected static void reload() {
		try {
			resetRegistry();
			ClientData.minecraft.method_1478().method_14488("perspective/shader_packs", identifier -> identifier.method_12832().endsWith(".json")).forEach((identifier, resource) -> {
				try (InputStream stream = resource.method_14482()) {
					JsonElement jsonElement = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
					JsonObject reader = jsonElement.getAsJsonObject();
					JsonArray defaultRegistryIds = new JsonArray();
					defaultRegistryIds.add(getShadersId().toString());
					JsonArray registryIds = class_3518.method_15292(reader, "registries", defaultRegistryIds);
					List<ShaderPackEntry.Shader> shaders = new ArrayList<>();
					for (JsonElement element : class_3518.method_15292(reader, "shaders", new JsonArray())) {
						if (element instanceof JsonObject shaderData) {
							List<ShaderPackEntry.Uniform> uniforms = new ArrayList<>();
							for (JsonElement uniformElement : class_3518.method_15292(shaderData, "uniforms", new JsonArray())) {
								if (uniformElement instanceof JsonObject uniform) {
									List<Float> uniformValues = new ArrayList<>();
									List<String> uniformOverrides = new ArrayList<>();
									for (JsonElement uniformValue : class_3518.method_15261(uniform, "values")) uniformValues.add(uniformValue.getAsFloat());
									for (JsonElement uniformOverride : class_3518.method_15261(uniform, "override")) uniformOverrides.add(uniformOverride.getAsString());
									uniforms.add(new ShaderPackEntry.Uniform(class_2960.method_60654(class_3518.method_15265(uniform, "post_effect")), class_3518.method_15265(uniform, "name"), uniformValues, uniformOverrides));
								}
							}
							shaders.add(new ShaderPackEntry.Shader(
									class_2960.method_60654(class_3518.method_15253(shaderData, "registry", Shaders.getMainRegistryId().toString())),
									class_2960.method_60654(class_3518.method_15265(shaderData, "luminance")),
									uniforms
							));
						}
					}
					class_2960 id = identifier.method_45136(identifier.method_12832().substring(identifier.method_12832().lastIndexOf("/") + 1, identifier.method_12832().lastIndexOf(".json")));
					registryIds.forEach((registryId) -> addToRegistry(class_2960.method_60654(registryId.getAsString()), id, new ShaderPackEntry.Translation(id, true), shaders, class_3518.method_15281(reader, "custom", new JsonObject())));
				} catch (Exception error) {
					Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to load shader pack '{}': {}", identifier.method_45136(identifier.method_12832().substring(identifier.method_12832().lastIndexOf("/") + 1, identifier.method_12832().lastIndexOf(".json"))), error.getLocalizedMessage()));
				}
			});
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, com.mclegoman.luminance.client.translation.Translation.getString("Failed to apply shader packs dataloader: {}", error));
		}
		addDefaultShaderPacks();
		clean();
	}
	private static void clean() {
		List<class_2960> remove = new ArrayList<>();
		registries.forEach((registryId, registry) -> {
			registry.forEach((id, shaderPack) -> {
				for (ShaderPackEntry.Shader shader : shaderPack.shaders()) {
					try {
						ShaderRegistryEntry shaderRegistryEntry = Shaders.get(shader.registry(), shader.luminance());
						if (shaderRegistryEntry == null) {
							Data.getVersion().sendToLog(LogType.WARN, shader.registry() + ":" + shader.luminance() + " returned null!");
							remove.add(id);
							break;
						}
						else ClientData.minecraft.method_1478().getResourceOrThrow(shaderRegistryEntry.getPostEffect(true));
					} catch (FileNotFoundException error) {
						Data.getVersion().sendToLog(LogType.WARN, error.getLocalizedMessage());
						remove.add(id);
						break;
					}
				}
			});
			remove.forEach(ShaderPacks::removeFromRegistry);
		});
	}
	public static class_7919 getTooltip() {
		return getTooltip(PerspectiveConfig.config.superSecretSettingsShader.value().getIdentifier());
	}
	public static class_7919 getTooltip(class_2960 shaderId) {
		ShaderPackEntry pack = getRegistry().get(shaderId);
		class_2561 description = pack != null ? pack.translation().getDescription(ShaderPacks.shouldShowNamespace(getShadersId(), pack.translation().id())) : null;
		return description != null && !description.getString().isEmpty() ? class_7919.method_47407(description) : null;
	}
	public static boolean exists(class_2960 shaderId) {
		return exists(getShadersId(), shaderId);
	}
	public static boolean exists(class_2960 registryId, class_2960 shaderId) {
		return getRegistry(registryId).containsKey(shaderId);
	}
	public static Optional<class_2960> guessPackId(@NotNull String id) {
		return guessPackId(getShadersId(), id);
	}
	public static Optional<class_2960> guessPackId(@NotNull class_2960 registry, @NotNull String id) {
		// If the shader registry contains at least one shader with the name, the first detected instance will be used.
		id = id.toLowerCase(Locale.ROOT);

		if (id.contains(":")) {
			class_2960 identifier = class_2960.method_12829(id);
			if (identifier == null) {
				return Optional.empty();
			}

			ShaderPackEntry entry = getShaderPack(registry, identifier);
			if (entry != null) {
				return Optional.of(identifier);
			}

			id = identifier.method_12832();
		}

		for (class_2960 shaderId : getRegistry(registry).keySet()) {
			if (shaderId.method_12832().equals(id)) {
				return Optional.of(shaderId);
			}
		}

		return Optional.empty();
	}
	static {
		random = new Random();
		registries = new HashMap<>();
		colors = new class_124[]{class_124.field_1058, class_124.field_1077, class_124.field_1062, class_124.field_1079, class_124.field_1064, class_124.field_1065, class_124.field_1078, class_124.field_1060, class_124.field_1075, class_124.field_1061, class_124.field_1076, class_124.field_1054};
	}
}
