/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.texture;

import com.mclegoman.luminance.common.util.DateHelper;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import java.time.LocalDate;
import java.time.Month;
import net.minecraft.class_2960;

public class TextureHelper {
	public static void init() {
		try {
			ResourcePacks.init();
		} catch (Exception error) {
			Data.getVersion().sendToLog(LogType.ERROR, Translation.getString("Failed to init texture helper: {}", error));
		}
	}
	public static class_2960 getTexture(class_2960 texture, class_2960 current) {
		String path = texture.method_12832();
		if (!path.equalsIgnoreCase("none")) {
			class_2960 textureId = texture;
			if (path.equalsIgnoreCase("developer_cape")) {
				LocalDate date = DateHelper.getDate();
				textureId = class_2960.method_60655(Data.getVersion().getID(), "textures/contributors/cape/dev_" + (((date.getYear() >= 2026) || date.getYear() == 2025 && (date.getMonth().getValue() >= Month.JULY.getValue() || (date.getMonth() == Month.JUNE && date.getDayOfMonth() >= 14))) ? "two" : "one") + "year.png");
			}
			return class_2960.method_60655(textureId.method_12836(), textureId.method_12832().endsWith(".png") ? textureId.method_12832() : textureId.method_12832() + ".png");
		}
		return current;
	}
	public static class_2960 getTexture(class_2960 texture, class_2960 current, class_2960 skin) {
		String path = texture.method_12832();
		if (path.equalsIgnoreCase("skin")) return skin;
		return getTexture(texture, current);
	}
}