/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.toasts;

import com.google.common.collect.ImmutableList;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.keybindings.KeybindingHelper;
import com.mclegoman.perspective.client.keybindings.Keybindings;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5481;

public class PerspectiveToast implements class_368 {
    private static final class_2960 TEXTURE = class_2960.method_60655(Data.getVersion().getID(), "toast/info");
    private static final int MIN_WIDTH = 200;
    private static final int WRAP_WIDTH = 320;
    private static final int LINE_HEIGHT = 12;

    private final Type type;
    private class_2561 title;
    private List<class_5481> lines;
    private long startTime;
    private boolean justUpdated;
    private final int width;
    private boolean hidden;
    private class_369 visibility;

    private PerspectiveToast(Type type, class_2561 title, List<class_5481> lines, int width) {
        this.visibility = class_369.field_2209;
        this.type = type;
        this.title = title;
        this.lines = lines;
        this.width = width;
    }

    public static PerspectiveToast create(class_310 client, Type type, class_2561 title, @Nullable class_2561 description) {
        class_327 textRenderer = client.field_1772;

        List<class_5481> wrappedLines = description != null
                ? textRenderer.method_1728(description, WRAP_WIDTH)
                : ImmutableList.of();

        int maxLineWidth = wrappedLines.stream()
                .mapToInt(textRenderer::method_30880)
                .max()
                .orElse(0);

        int width = Math.max(MIN_WIDTH, 30 + Math.max(textRenderer.method_27525(title), maxLineWidth));

        return new PerspectiveToast(type, title, wrappedLines, width);
    }

    public int method_29049() {
        return this.width;
    }

    public int method_29050() {
        return 20 + Math.max(this.lines.size(), 1) * LINE_HEIGHT;
    }

    public void hide() {
        this.hidden = true;
    }

    public class_369 method_61988() {
        return this.visibility;
    }

    public void method_61989(class_374 manager, long time) {
        if (this.justUpdated) {
            this.startTime = time;
            this.justUpdated = false;
        }

        double duration = (double)this.type.displayDuration * manager.method_48221();
        long elapsed = time - this.startTime;
        this.visibility = !this.hidden && (double)elapsed < duration ? class_369.field_2210 : class_369.field_2209;
    }

    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        context.method_52706(class_1921::method_62277, TEXTURE, 0, 0, this.method_29049(), this.method_29050());
        context.method_51439(textRenderer, this.title, 26, 7, 0xFFAA00, false);

        for (int i = 0; i < this.lines.size(); ++i) {
            context.method_51430(textRenderer, this.lines.get(i), 26, 18 + i * LINE_HEIGHT, 0xFFFFFF, false);
        }
    }

    public void setContent(class_2561 title, @Nullable class_2561 description) {
        this.title = title;
        this.lines = description == null
                ? ImmutableList.of()
                : class_310.method_1551().field_1772.method_1728(description, MIN_WIDTH);
        this.justUpdated = true;
    }

    public Type method_1987() {
        return this.type;
    }

    public static void show(class_310 client, Type type, class_2561 title, @Nullable class_2561 description) {
        client.method_1566().method_1999(PerspectiveToast.create(client, type, title, description));
    }

    public static class Type {
        public static final Type TUTORIAL = new Type();
        public static final Type WARNING = new Type();
        public static final Type UPDATE = new Type();

        final long displayDuration;

        public Type(long displayDuration) {
            this.displayDuration = displayDuration;
        }
        public Type() {
            this(5000L);
        }
    }

    public static class Helper {
        public static final boolean experimentsAvailable = false;
        private static boolean seenDevelopmentWarning = false;
        private static boolean showDowngradeWarning = false;
        private static boolean seenDowngradeWarning = false;
        public static boolean seenConflictingKeybindingToasts = false;
        public static void showDowngradeWarning() {
            showDowngradeWarning = true;
        }
        public static void tick() {
            if (!seenDevelopmentWarning && Data.getVersion().isDevelopmentBuild()) {
                Data.getVersion().sendToLog(LogType.INFO, "Development Build: Please submit a bug report if you encounter any issues.");
                show(ClientData.minecraft, Type.WARNING, Translation.getTranslation(Data.getVersion().getID(), "toasts.title", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name"), Translation.getTranslation(Data.getVersion().getID(), "toasts.development_warning.title")}), Translation.getTranslation(Data.getVersion().getID(), "toasts.development_warning.description"));
                seenDevelopmentWarning = true;
            }
            if (!seenDowngradeWarning && showDowngradeWarning) {
                Data.getVersion().sendToLog(LogType.INFO, "Downgrading is not supported: You may experience configuration related issues.");
                show(ClientData.minecraft, Type.WARNING, Translation.getTranslation(Data.getVersion().getID(), "toasts.title", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name"), Translation.getTranslation(Data.getVersion().getID(), "toasts.downgrade_warning.title")}), Translation.getTranslation(Data.getVersion().getID(), "toasts.downgrade_warning.description"));
                seenDowngradeWarning = true;
            }
            if (!seenConflictingKeybindingToasts && KeybindingHelper.hasKeybindingConflicts(Keybindings.allKeybindings)) {
                Data.getVersion().sendToLog(LogType.INFO, Translation.getString("Conflicting Keybinding: Keybinding conflicts have been detected."));
                show(ClientData.minecraft, Type.WARNING, Translation.getTranslation(Data.getVersion().getID(), "toasts.title", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name"), Translation.getTranslation(Data.getVersion().getID(), "toasts.keybinding_conflicts.title")}), Translation.getTranslation(Data.getVersion().getID(), "toasts.keybinding_conflicts.description"));
                seenConflictingKeybindingToasts = true;
            }
        }
    }
}