/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.translation;

import com.mclegoman.perspective.client.config.value.QualityToggle;
import com.mclegoman.perspective.client.events.PerspectiveExecute;
import com.mclegoman.perspective.client.hide.Hide;
import com.mclegoman.perspective.client.zoom.Zoom;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.text.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Translation extends com.mclegoman.luminance.client.translation.Translation {
	public static String getTitleCase(String key) {
		if (key != null && !key.isEmpty()) {
			String[] words = key.replace('_', ' ').split(" ");
			StringBuilder result = new StringBuilder();
			for (String word : words) {
				if (!word.isEmpty()) result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
			}
			return result.toString().trim();
		}
		return key;
	}
	public static class_5250 getCombinedText(List<class_5250> texts) {
		return getCombinedText(texts.toArray(new class_5250[0]));
	}
	public static class_5250 getQualityTranslation(String namespace, QualityToggle type) {
		return type.asString().equalsIgnoreCase("off") ? getVariableTranslation(namespace, false, Type.ONFF) : getTranslation(namespace, "quality." + type.asString());
	}
	public static class_5250 getVariableTranslation(String namespace, boolean toggle, Type type) {
		return toggle ? getTranslation(namespace, "variable." + type.method_15434() + ".on") : getTranslation(namespace, "variable." + type.method_15434() + ".off");
	}
	public static class_5250 getShaderTranslation(String namespace, String shaderName) {
		return getText("shader." + namespace + "." + shaderName, true);
	}
	public static class_5250 getShaderModeTranslation(String namespace, String key, boolean hover) {
		if (key.equalsIgnoreCase("game")) return getConfigTranslation(namespace, "shaders.super_secret_settings.mode.game", hover);
		else if (key.equalsIgnoreCase("ui") || key.equalsIgnoreCase("screen")) return getConfigTranslation(namespace, "shaders.super_secret_settings.mode.ui", hover);
		else return getErrorTranslation(namespace);
	}
	public static class_5250 getShaderModeTranslation(String namespace, String key) {
		return getShaderModeTranslation(namespace, key, false);
	}
	public static class_5250 getZoomTransitionTranslation(String namespace, String key) {
		if (key.equalsIgnoreCase("instant")) return getConfigTranslation(namespace, "zoom.transition.instant");
		else if (key.equalsIgnoreCase("smooth")) return getConfigTranslation(namespace, "zoom.transition.smooth");
		else return getErrorTranslation(namespace);
	}
	public static class_5250 getZoomScaleModeTranslation(String namespace, String key) {
		if (key.equalsIgnoreCase("scaled")) return getConfigTranslation(namespace, "zoom.scale_mode.scaled");
		else if (key.equalsIgnoreCase("vanilla")) return getConfigTranslation(namespace, "zoom.scale_mode.vanilla");
		else return getErrorTranslation(namespace);
	}
	public static class_5250 getZoomTypeTranslation(String namespace, String zoomType, boolean hover) {
		if (Zoom.isValidZoomType(Zoom.getZoomType())) {
			return getConfigTranslation(namespace, "zoom.type." + zoomType + (hover ? ".hover" : ""));
		}
		return getErrorTranslation(namespace);
	}
	public static class_5250 getZoomTypeTranslation(String namespace, String zoomType) {
		return getZoomTypeTranslation(namespace, zoomType, false);
	}
	public static class_5250 getUIBackgroundTranslation(String namespace, class_2960 ui_background) {
		return getUIBackgroundTranslation(namespace, ui_background, false);
	}
	public static class_5250 getUIBackgroundTranslation(String namespace, class_2960 ui_background, boolean hover) {
		return getConfigTranslation(namespace, "shaders.ui_background.type." + ui_background.method_12836() + "." + ui_background.method_12832() + (hover ? ".hover" : ""));
	}
	public static class_5250 getTimeOverlayTranslation(String namespace, String key) {
		return getConfigTranslation(namespace, "time_overlay.type." + key);
	}
	public static class_5250 getCrosshairTranslation(String namespace, String key) {
		if (Arrays.stream(Hide.hideCrosshairModes).toList().contains(key)) return getConfigTranslation(namespace, "crosshair.type." + key);
		else return getErrorTranslation(namespace);
	}
	public static class_5250 getDetectUpdateChannelTranslation(String namespace, String key) {
		if (key.equalsIgnoreCase("none")) return getConfigTranslation(namespace, "detect_update_channel.none");
		else if (key.equalsIgnoreCase("alpha")) return getConfigTranslation(namespace, "detect_update_channel.alpha");
		else if (key.equalsIgnoreCase("beta")) return getConfigTranslation(namespace, "detect_update_channel.beta");
		else if (key.equalsIgnoreCase("release")) return getConfigTranslation(namespace, "detect_update_channel.release");
		else return getErrorTranslation(namespace);
	}
	public static class_5250 getItemGroupTranslation(String namespace, String key, Object[] variables, class_124[] formattings) {
		return getTranslation("item_group", namespace, key, variables, formattings);
	}
	public static class_5250 getItemGroupTranslation(String namespace, String key, Object[] variables) {
		return getTranslation("item_group", namespace, key, variables);
	}
	public static class_5250 getItemGroupTranslation(String namespace, String key, class_124[] formattings) {
		return getTranslation("item_group", namespace, key, formattings);
	}
	public static class_5250 getItemGroupTranslation(String namespace, String key) {
		return getTranslation("item_group", namespace, key);
	}
	public static class_5250 getZoomSmoothSpeedTranslation(String namespace, float value) {
		return getConfigTranslation(namespace, "zoom.smooth_speed." + (value <= 0.01F ? "min" : (value == 1.0F ? "normal" : (value >= 2.0F ? "max" : "value"))), new Object[]{value});
	}
	public enum Type implements class_3542 {
		ENDISABLE("endisable"),
		ONFF("onff"),
		BLUR("blur");
		private final String name;
		Type(String name) {
			this.name = name;
		}
		@Override
		public String method_15434() {
			return this.name;
		}
	}
	public static class_2561 getParsedTextFromString(String input) {
		class_2561 parsed = tryParse(input.trim());
		if (parsed != null) return parsed;
		return class_2561.method_43470(input.trim());
	}
	private static class_2561 tryParse(String input) {
		Pattern pattern = Pattern.compile("^(Translatable|Variable)\\[([^]]+)](?:\\((.*)\\))?$");
		Matcher matcher = pattern.matcher(input);
		if (!matcher.matches()) return null;
		String type = matcher.group(1);
		String key = matcher.group(2);
		String argsGroup = matcher.group(3);
		List<class_2561> args = argsGroup == null || argsGroup.isEmpty() ? List.of() : splitArgs(argsGroup).stream().map(Translation::getParsedTextFromString).toList();
		if ("Translatable".equals(type)) return class_2561.method_43469(key, args.toArray());
		else if ("Variable".equals(type)) {
			return PerspectiveExecute.getVariable(class_2960.method_60654(key), argsGroup != null ? splitArgs(argsGroup).toArray(new String[0]) : new String[]{});
		}
		return null;
	}
	private static List<String> splitArgs(String argsString) {
		List<String> result = new ArrayList<>();
		int depth = 0;
		StringBuilder current = new StringBuilder();
		for (int i = 0; i < argsString.length(); i++) {
			char c = argsString.charAt(i);
			if (c == '(' || c == '[') depth++;
			else if (c == ')' || c == ']') depth--;
			if (c == ',' && depth == 0) {
				result.add(current.toString().trim());
				current.setLength(0);
			} else current.append(c);
		}
		if (!current.isEmpty()) result.add(current.toString().trim());
		return result;
	}
	public static String getStringFromText(class_2561 text) {
		if (text.method_10851() instanceof class_2588 translatable) {
			Object[] args = translatable.method_11023();
			StringBuilder arguments = new StringBuilder();
			for (int i = 0; i < args.length; i++) {
				arguments.append(args[i].toString());
				if (i < args.length - 1) arguments.append(", ");
			}
			return "Translatable[" + translatable.method_11022() + "]" + (!arguments.isEmpty() ? "(" + arguments + ")" : "");
		}
		return text.method_54160();
	}
	public static String getTranslationKey(String namespace, String key) {
		return "gui." + namespace + "." + key;
	}
}