/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.ui;

import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.client.config.value.ConfigIdentifier;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.common.util.Identifiers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class UIBackground {
	private static final List<UIBackgroundData> uiBackgroundTypes = new ArrayList<>();
	public static void init() {
		registerUIBackground(new UIBackgroundData.Builder(Identifiers.DEFAULT).build());
		registerUIBackground(new UIBackgroundData.Builder(Identifiers.GAUSSIAN).shaderId(class_2960.method_60655(Data.getVersion().getID(), "gaussian")).build());
		registerUIBackground(new UIBackgroundData.Builder(Identifiers.LEGACY).renderWorld(context -> {
				RenderSystem.enableBlend();
				context.method_25296(0, 0, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), -1072689136, -804253680);
				RenderSystem.disableBlend();
			}).renderMenu(context -> {
				RenderSystem.enableBlend();
				context.method_25290(class_1921::method_62277, getUiBackgroundTextureFromConfig(), 0, 0, 0, 0.0F, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 32);
				context.method_25290(class_1921::method_62277, class_2960.method_60655(Data.getVersion().getID(), "textures/gui/uibackground_menu_background.png"), 0, 0, 0, 0.0F, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 32);
				RenderSystem.disableBlend();
		}).renderPanorama(false).renderShader(false).build());
		registerUIBackground(new UIBackgroundData.Builder(Identifiers.CLASSIC).renderWorld(context -> {
				RenderSystem.enableBlend();
				context.method_25296(0, 0, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), -1072689136, -804253680);
				RenderSystem.disableBlend();
			}).renderMenu(context -> {
				RenderSystem.enableBlend();
				context.method_25290(class_1921::method_62277, getUiBackgroundTextureFromConfig(), 0, 0, 0.0F, 0.0F, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 32);
				context.method_25290(class_1921::method_62277, class_2960.method_60655(Data.getVersion().getID(), "textures/gui/uibackground_menu_background.png"), 0, 0, 0, 0.0F, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 32);
				RenderSystem.disableBlend();
			}).renderTitleScreen(context -> {
				RenderSystem.enableBlend();
				context.method_25290(class_1921::method_62277, getUiBackgroundTextureFromConfig(), 0, 0, 0.0F, 0.0F, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 32);
				context.method_25290(class_1921::method_62277, class_2960.method_60655(Data.getVersion().getID(), "textures/gui/uibackground_menu_background.png"), 0, 0, 0, 0.0F, ClientData.minecraft.method_22683().method_4486(), ClientData.minecraft.method_22683().method_4502(), 32, 32);
				RenderSystem.disableBlend();
		}).renderPanorama(false).renderTitleScreenPanorama(false).renderShader(false).build());
		registerUIBackground(new UIBackgroundData.Builder(Identifiers.NONE).renderShader(false).renderDarkening(false).build());
	}
	public static void registerUIBackground(UIBackgroundData data) {
		if (!ClientData.minecraft.method_53466()) {
			boolean alreadyRegistered = isValidUIBackground(data.getId());
			if (!alreadyRegistered) uiBackgroundTypes.add(data);
			else Data.getVersion().sendToLog(LogType.WARN, Translation.getString("UI Background with id '{}' could not be registered: UI Background is already registered!", data.getId()));
		} else Data.getVersion().sendToLog(LogType.WARN, Translation.getString("UI Background with id '{}' could not be registered: Config has already been initialized!", data.getId()));
	}
	public static boolean isValidUIBackground(class_2960 id) {
		for (UIBackgroundData uiData : uiBackgroundTypes) {
			if (id.equals(uiData.getId())) return true;
		}
		return false;
	}
	public static void cycleUIBackgroundType() {
		cycleUIBackgroundType(true);
	}
	public static void cycleUIBackgroundType(boolean direction) {
		int currentIndex = uiBackgroundTypes.indexOf(getCurrentUIBackground());
		PerspectiveConfig.config.uiBackground.setValue(ConfigIdentifier.of(uiBackgroundTypes.get(direction ? (currentIndex + 1) % uiBackgroundTypes.size() : (currentIndex - 1 + uiBackgroundTypes.size()) % uiBackgroundTypes.size()).getId()), false);
	}
	public static UIBackgroundData getCurrentUIBackground() {
		return getUIBackgroundType(PerspectiveConfig.config.uiBackground.value().getIdentifier());
	}
	public static UIBackgroundData getUIBackgroundType(class_2960 type) {
		for (UIBackgroundData data : uiBackgroundTypes) {
			if (data.getId().equals(type)) return data;
		}
		return UIBackgroundData.Builder.getFallback();
	}
	public static boolean isRegisteredUIBackgroundType(class_2960 type) {
		for (UIBackgroundData data : uiBackgroundTypes) {
			if (data.getId().equals(type)) return true;
		}
		return false;
	}
	public static class_2960 getUiBackgroundTextureFromConfig() {
		class_2960 uiBackgroundTexture = PerspectiveConfig.config.uiBackgroundTexture.value().getIdentifier();
		String namespace = IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, uiBackgroundTexture.method_12836());
		String key = IdentifierHelper.getStringPart(IdentifierHelper.Type.KEY, uiBackgroundTexture.method_12832());
		return (namespace != null && key != null) ? class_2960.method_60655(namespace, (!key.startsWith("textures/") ? "textures/" : "") + key + (!key.endsWith(".png") ? ".png" : "")) : class_2960.method_60655("minecraft", "textures/block/dirt.png");
	}
	public static class_2960 getUIBackgroundId() {
		return Identifiers.UI_BACKGROUND;
	}
	public interface Runnable {
		void run(class_332 context);
	}
}