/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.client.util;

import com.mclegoman.luminance.common.util.LogType;
import com.mclegoman.perspective.common.data.Data;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public class Position {
	private static final Map<String, Boolean> hidePos = new HashMap<>();
	public static void register(String modId) {
		if (shouldShowPos()) Data.getVersion().sendToLog(LogType.INFO, "Positional data will now be obfuscated.");
		hidePos.putIfAbsent(modId, true);
	}
	public static boolean shouldShowPos() {
		return hidePos.isEmpty();
	}
	public static String getX(class_243 pos, boolean integer) {
		return !shouldShowPos() ? "?" : (integer ? String.valueOf((int) pos.field_1352) : String.valueOf(pos.field_1352));
	}
	public static String getX(class_243 pos) {
		return getX(pos, false);
	}
	public static String getX(class_1309 entity) {
		return getX(entity.method_19538());
	}
	public static String getX(class_1309 entity, boolean integer) {
		return getX(entity.method_19538(), integer);
	}
	public static String getY(class_243 pos, boolean integer) {
		return !shouldShowPos() ? "?" : (integer ? String.valueOf((int) pos.field_1351) : String.valueOf(pos.field_1351));
	}
	public static String getY(class_243 pos) {
		return getY(pos, false);
	}
	public static String getY(class_1309 entity) {
		return getY(entity.method_19538());
	}
	public static String getY(class_1309 entity, boolean integer) {
		return getY(entity.method_19538(), integer);
	}
	public static String getZ(class_243 pos, boolean integer) {
		return !shouldShowPos() ? "?" : (integer ? String.valueOf((int) pos.field_1350) : String.valueOf(pos.field_1350));
	}
	public static String getZ(class_243 pos) {
		return getZ(pos, false);
	}
	public static String getZ(class_1309 entity) {
		return getZ(entity.method_19538());
	}
	public static String getZ(class_1309 entity, boolean integer) {
		return getZ(entity.method_19538(), integer);
	}
}
