/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.appearance;

import com.mclegoman.perspective.client.appearance.Appearance;
import com.mclegoman.perspective.client.contributor.Contributor;
import com.mclegoman.perspective.client.contributor.ContributorData;
import com.mclegoman.perspective.client.events.AprilFoolsPrank;
import com.mclegoman.perspective.client.events.AprilFoolsPrankDataLoader;
import com.mclegoman.perspective.client.texture.TextureHelper;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_8685;

@Mixin(priority = 100, value = class_742.class)
public class AbstractClientPlayerEntityMixin {
	@Shadow
	@Nullable
	private class_640 playerListEntry;

	@Inject(method = "getSkinTextures", at = @At("TAIL"), cancellable = true)
	private void getSkinTextures(CallbackInfoReturnable<class_8685> cir) {
		if (this.playerListEntry != null) {
			boolean isAprilFools = PerspectiveConfig.config.allowAprilFools.value() && AprilFoolsPrank.isAprilFools() && !AprilFoolsPrankDataLoader.registry.isEmpty();
			class_8685 currentSkinTextures = cir.getReturnValue();
			class_2960 skinTexture = currentSkinTextures.comp_1626();
			class_2960 capeTexture = currentSkinTextures.comp_1627();
			class_8685.class_7920 model = currentSkinTextures.comp_1629();
			UUID uuid = this.playerListEntry.method_2966().getId();
			String stringifiedUUID = String.valueOf(uuid);
			if (isAprilFools) {
				AprilFoolsPrank.PrankTexture texture = AprilFoolsPrank.getTexture(uuid);
				skinTexture = texture.texture();
				model = texture.isSlim() ? class_8685.class_7920.field_41122 : class_8685.class_7920.field_41123;
				stringifiedUUID = texture.contributor();
			} else {
				Appearance.Data appearance = Appearance.DataLoader.registry.get(stringifiedUUID);
				if (appearance != null) {
					skinTexture = TextureHelper.getTexture(appearance.texture(), skinTexture);
					model = appearance.model();
				}
			}
			ContributorData developer = Contributor.getContributorData(stringifiedUUID);
			if (developer != null && developer.getShouldReplaceCape()) capeTexture = TextureHelper.getTexture(developer.getCapeTexture(), capeTexture);
			cir.setReturnValue(new class_8685(skinTexture, currentSkinTextures.comp_1911(), capeTexture, capeTexture, model, currentSkinTextures.comp_1630()));
		}
	}
}