/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.contributor;

import com.mclegoman.perspective.client.contributor.Contributor;
import com.mclegoman.perspective.client.contributor.ContributorData;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_922.class)
public abstract class LivingEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "shouldFlipUpsideDown", cancellable = true)
	private static void perspective$shouldFlipUpsideDown(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {		
		if (entity instanceof class_1657) {
			ContributorData data = Contributor.getContributorData(((class_1657) entity).method_7334().getId().toString());
			if (data != null) cir.setReturnValue(data.getShouldFlipUpsideDown());
		}
	}
}