/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.contributor;

import com.mclegoman.perspective.client.contributor.Contributor;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.renderer.feature.ContributorOverlayFeatureRenderer;
import com.mclegoman.perspective.client.entity.renderer.feature.PlayerFaceFeatureRenderer;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_1007.class)
public abstract class PlayerEntityRendererMixin extends class_922<class_742, class_10055, class_591> {
	public PlayerEntityRendererMixin(class_5617.class_5618 ctx, class_591 model, float shadowRadius) {
		super(ctx, model, shadowRadius);
	}
	@Inject(method = "<init>", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, boolean slim, CallbackInfo ci) {
		this.method_4046(new ContributorOverlayFeatureRenderer<>(this, new class_591(context.method_32167(slim ? EntityModels.contributorOverlaySlim : EntityModels.contributorOverlayWide), slim)));
		this.method_4046(new PlayerFaceFeatureRenderer(this, context.method_32170()));
	}
	@Inject(method = "renderArm", at = @At("RETURN"))
	private void perspective$renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_2960 skinTexture, class_630 arm, boolean sleeveVisible, CallbackInfo ci) {
		if (ClientData.minecraft.field_1724 != null) {
			class_2960 texture = Contributor.getOverlayTexture(ClientData.minecraft.field_1724.method_5667().toString());
			if (texture != null) arm.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_23580(texture)), light, class_4608.field_21444);
		}
	}
}