/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.entity;

import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_897.class)
public abstract class EntityRendererMixin<T extends class_1297, S extends class_10017> {
	@Inject(method = "updateRenderState", at = @At("TAIL"))
	private void perspective$updateRenderState(T entity, S state, float tickDelta, CallbackInfo ci) {
		((PerspectiveRenderState)state).perspective$setUUID(entity.method_5667());
		((PerspectiveRenderState)state).perspective$setType(entity.method_5864());
		((PerspectiveRenderState)state).perspective$setStringName(entity.method_5797() != null ? entity.method_5797().method_54160() : "default");
	}
}
