/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hide;

import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import com.mclegoman.perspective.client.hide.Hide;
import net.minecraft.class_10034;
import net.minecraft.class_10055;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_970.class)
public abstract class ArmorFeatureRendererMixin<S extends class_10034, M extends class_572<S>, A extends class_572<S>> extends class_3887<S, M> {
	public ArmorFeatureRendererMixin(class_3883<S, M> context) {
		super(context);
	}
	@Inject(method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/BipedEntityRenderState;FF)V", at = @At("HEAD"), cancellable = true)
	private void perspective$hide_armor(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, S bipedEntityRenderState, float f, float g, CallbackInfo ci) {
		if (bipedEntityRenderState instanceof class_10055 && Hide.shouldHideArmor(((PerspectiveRenderState)bipedEntityRenderState).perspective$getUUID())) {
			ci.cancel();
		}
	}
}