/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hide;

import com.mclegoman.perspective.client.hud.HUDHelper;
import net.minecraft.class_757;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_757.class)
public abstract class GameRendererMixin {
	@Inject(at = @At("HEAD"), method = "shouldRenderBlockOutline", cancellable = true)
	private void perspective$renderBlockOutline(CallbackInfoReturnable<Boolean> cir) {
		if ((HUDHelper.shouldHideHUD()) || PerspectiveConfig.config.hideBlockOutline.value())
			cir.setReturnValue(false);
	}
}