/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hide;

import com.mclegoman.perspective.client.hide.DynamicCrosshairDataLoader;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4061;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_329.class)
public abstract class InGameHudMixin {
	@Shadow
	@Final
	private static class_2960 CROSSHAIR_ATTACK_INDICATOR_FULL_TEXTURE;

	@Shadow
	@Final
	private static class_2960 CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_TEXTURE;

	@Shadow
	@Final
	private static class_2960 CROSSHAIR_ATTACK_INDICATOR_PROGRESS_TEXTURE;

	@Inject(at = @At("HEAD"), method = "renderCrosshair", cancellable = true)
	private void perspective$renderCrosshair(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
		if (ClientData.minecraft.field_1687 != null && ClientData.minecraft.field_1724 != null) {
			if ((PerspectiveConfig.config.crosshairType.value().equals("hidden")) || (PerspectiveConfig.config.crosshairType.value().equals("dynamic"))) {
				class_239 crosshairTarget = ClientData.minecraft.field_1765;
				boolean hide_crosshair = (PerspectiveConfig.config.crosshairType.value().equals("hidden"));
				if (crosshairTarget != null) {
					if ((PerspectiveConfig.config.crosshairType.value().equals("dynamic"))) {
						hide_crosshair = (crosshairTarget.method_17783() == class_239.class_240.field_1332) ? ClientData.minecraft.field_1687.method_8320(((class_3965) crosshairTarget).method_17777()).method_26215() : crosshairTarget.method_17783() != class_239.class_240.field_1331;
						if (DynamicCrosshairDataLoader.activeRegistry.contains(ClientData.minecraft.field_1724.method_6030().method_7909())) hide_crosshair = false;
						for (class_1799 itemStack : ClientData.minecraft.field_1724.method_5877()) {
							if (DynamicCrosshairDataLoader.heldRegistry.contains(itemStack.method_7909())) hide_crosshair = false;
							class_9278 chargedProjectilesComponent = itemStack.method_57824(class_9334.field_49649);
							if (chargedProjectilesComponent != null && !chargedProjectilesComponent.method_57442()) {
								hide_crosshair = false;
								break;
							}
						}
					}
					if (hide_crosshair) {
						RenderSystem.enableBlend();
						RenderSystem.blendFuncSeparate(GlStateManager.class_4535.ONE_MINUS_DST_COLOR, GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
						if (ClientData.minecraft.field_1690.method_42565().method_41753() == class_4061.field_18152) {
							if (ClientData.minecraft.field_1724 != null) {
								if (!ClientData.minecraft.field_1773.method_35765()) {
									float cooldownProgress = ClientData.minecraft.field_1724.method_7261(0.0F);
									boolean cooldownProgressFull = false;
									if (ClientData.minecraft.field_1692 instanceof class_1309 && cooldownProgress >= 1.0F) {
										cooldownProgressFull = ClientData.minecraft.field_1724.method_7279() > 5.0F;
										cooldownProgressFull &= ClientData.minecraft.field_1692.method_5805();
									}
									int j = ClientData.minecraft.method_22683().method_4502() / 2 - 7 + 16;
									int k = ClientData.minecraft.method_22683().method_4486() / 2 - 8;
									if (cooldownProgressFull) {
										context.method_52706(class_1921::method_62277, CROSSHAIR_ATTACK_INDICATOR_FULL_TEXTURE, k, j, 16, 16);
									} else if (cooldownProgress < 1.0F) {
										int l = (int) (cooldownProgress * 17.0F);
										context.method_52706(class_1921::method_62277, CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_TEXTURE, k, j, 16, 4);
										context.method_52708(class_1921::method_62277, CROSSHAIR_ATTACK_INDICATOR_PROGRESS_TEXTURE, 16, 4, 0, 0, k, j, l, 4);
									}
								}
							}
						}
						RenderSystem.defaultBlendFunc();
						RenderSystem.disableBlend();
						ci.cancel();
					}
				}
			}
		}
	}
}