/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hide;

import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.hide.Hide;
import com.mclegoman.perspective.client.hide.HideNameTagsDataLoader;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_922;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_922.class)
public abstract class LivingEntityRendererMixin<T extends class_1309, S extends class_10042, M extends class_583<? super S>> {
	@Inject(method = "hasLabel(Lnet/minecraft/entity/LivingEntity;D)Z", at = @At("HEAD"), cancellable = true)
	private void perspective$hide_nametag(T entity, double d, CallbackInfoReturnable<Boolean> cir) {
		if (ClientData.minecraft.field_1773.method_35765() || PerspectiveConfig.config.hideNametags.value() || (entity instanceof class_1657 && HideNameTagsDataLoader.registry.contains(String.valueOf((((class_1657) entity).method_7334().getId())))))
			cir.setReturnValue(false);
		if (entity instanceof class_1657) {
			if (Hide.shouldHidePlayer(entity.method_5667())) cir.setReturnValue(false);
		}
	}
	@Inject(method = "render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V", at = @At("HEAD"), cancellable = true)
	private void perspective$hide_nametag(S livingEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
		if (livingEntityRenderState instanceof class_10055 && Hide.shouldHidePlayer(((PerspectiveRenderState)livingEntityRenderState).perspective$getUUID())) ci.cancel();
	}
}