/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hide;

import com.mclegoman.perspective.client.hide.Hide;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(priority = 100, value = class_761.class)
public abstract class WorldRendererMixin {
	@ModifyArgs(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/VertexRendering;drawOutline(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/util/shape/VoxelShape;DDDI)V"), method = "drawBlockOutline")
	private void perspective$drawBlockOutline(Args args) {
		args.set(args.size() - 1, Hide.getARGB(Hide.getRainbowBlockOutline() ? Hide.getRainbowOutline() : args.get(args.size() - 1), (int)((Hide.getBlockOutlineLevel() / 100.0F) * 255.0F)));
	}
}