/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hud;

import com.mclegoman.perspective.client.hud.HUDHelper;
import net.minecraft.class_338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_338.class)
public abstract class ChatHudMixin {
	@Inject(at = @At("RETURN"), method = "isChatHidden", cancellable = true)
	private void perspective$isChatHidden(CallbackInfoReturnable<Boolean> cir) {
		if (HUDHelper.shouldHideHUD()) cir.setReturnValue(true);
	}
}