/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hud;

import com.llamalad7.mixinextras.sugar.Local;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.hud.HUDHelper;
import com.mclegoman.perspective.client.hud.Overlays;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_329.class)
public abstract class InGameHudMixin {
	@Shadow @Nullable protected abstract class_1657 getCameraPlayer();
	@Shadow protected abstract void renderHotbarItem(class_332 context, int x, int y, class_9779 tickCounter, class_1657 player, class_1799 stack, int seed);
	@Inject(at = @At("HEAD"), method = "render", cancellable = true)
	private void perspective$render(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
		if (HUDHelper.shouldHideHUD()) ci.cancel();
	}
	@Inject(at = @At("RETURN"), method = "render")
	private void perspective$renderOverlays(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
		Overlays.renderOverlays(context);
	}
	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/option/GameOptions;getAttackIndicator()Lnet/minecraft/client/option/SimpleOption;"), method = "renderHotbar")
	private void perspective$renderArmorHud(class_332 context, class_9779 tickCounter, CallbackInfo ci, @Local int l) {
		if (PerspectiveConfig.config.armorOverlay.value()) {
			class_1657 player = this.getCameraPlayer();
			if (player != null) {
				context.method_51448().method_22903();
				context.method_51448().method_46416(0.0F, 0.0F, -90.0F);
				int x = (context.method_51421() / 2) + (player.method_6068().method_5928().equals(class_1306.field_6182) ? 98 : -180);
				int y = context.method_51443() - 22;
				context.method_52706(class_1921::method_62277, class_2960.method_60655(Data.getVersion().getID(), "hud/armor"), x, y, 82, 22);
				if (player.method_6118(class_1304.field_6169).method_7960()) context.method_52706(class_1921::method_62277, class_2960.method_60654("container/slot/helmet"), x + 3, y + 3, 16, 16);
				else this.renderHotbarItem(context, x + 3, y + 3, tickCounter, player, player.method_6118(class_1304.field_6169), l++);
				if (player.method_6118(class_1304.field_6174).method_7960()) context.method_52706(class_1921::method_62277, class_2960.method_60654("container/slot/chestplate"), x + 23, y + 3, 16, 16);
				else this.renderHotbarItem(context, x + 23, y + 3, tickCounter, player, player.method_6118(class_1304.field_6174), l++);
				if (player.method_6118(class_1304.field_6172).method_7960()) context.method_52706(class_1921::method_62277, class_2960.method_60654("container/slot/leggings"), x + 43, y + 3, 16, 16);
				else this.renderHotbarItem(context, x + 43, y + 3, tickCounter, player, player.method_6118(class_1304.field_6172), l++);
				if (player.method_6118(class_1304.field_6166).method_7960()) context.method_52706(class_1921::method_62277, class_2960.method_60654("container/slot/boots"), x + 63, y + 3, 16, 16);
				else this.renderHotbarItem(context, x + 63, y + 3, tickCounter, player, player.method_6118(class_1304.field_6166), l++);
				context.method_51448().method_22909();
			}
		}
	}
}