/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hud;

import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.util.Mouse;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_310.class)
public abstract class MinecraftClientMixin {
	@Inject(at = @At("RETURN"), method = "render")
	private void perspective$render(CallbackInfo ci) {
		if (Mouse.ProcessCPS.shouldProcessCPS()) {
			Mouse.updateLeftClick(ClientData.minecraft.field_1729.method_1608());
			Mouse.updateMiddleClick(ClientData.minecraft.field_1729.method_35707());
			Mouse.updateRightClick(ClientData.minecraft.field_1729.method_1609());
		} else Mouse.clearQueues();
	}
}