/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.hud;

import com.mclegoman.luminance.client.util.CompatHelper;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.screen.config.ConfigScreen;
import com.mclegoman.perspective.client.screen.widget.LogoButtonWidget;
import com.mclegoman.perspective.client.translation.Translation;
import com.mclegoman.perspective.common.data.Data;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_446;
import net.minecraft.class_4667;
import net.minecraft.class_7919;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(priority = 100, value = class_446.class)
public abstract class VideoOptionsScreenMixin extends class_4667 {
	@Unique
	private class_4185 perspective$widget;
	public VideoOptionsScreenMixin(class_437 parent, class_315 gameOptions, class_2561 title) {
		super(parent, gameOptions, title);
	}
	protected void method_31387() {
		super.method_31387();
		perspective$widget = LogoButtonWidget.create(() -> {
			String path = FabricLoader.getInstance().getModContainer(Data.getVersion().getID()).get().getMetadata().getIconPath(64).orElse(null);
			if (CompatHelper.shouldOverrideModMenuIcon(Data.getVersion().getID())) path = CompatHelper.getOverrideModMenuIcon(Data.getVersion().getID());
			if (path != null) {
				path = path.replaceFirst("assets/", "").replaceFirst("/", ":");
			}
			return path != null ? class_2960.method_60654(path) : null;
		}, (button) -> ClientData.minecraft.method_1507(new ConfigScreen(this, 1))).width(20).position(2, perspective$getY()).tooltip(class_7919.method_47407(Translation.getTranslation(Data.getVersion().getID(), "config", new Object[]{Translation.getTranslation(Data.getVersion().getID(), "name"), Translation.getConfigTranslation(Data.getVersion().getID(), "config")}))).build();
		this.method_37063(perspective$widget);
	}
	protected void method_48640() {
		super.method_48640();
		perspective$widget.method_48229(2, perspective$getY());
	}
	@Unique
	private int perspective$getY() {
		assert ClientData.minecraft.field_1755 != null;
		return ClientData.minecraft.field_1755.field_22790 - (this.field_49503.method_48994() / 2) - 10;
	}
}