/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.perspective;

import com.mclegoman.perspective.client.config.PerspectiveConfig;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.perspective.Perspective;
import com.mclegoman.perspective.client.zoom.Zoom;
import net.minecraft.class_312;
import net.minecraft.class_9928;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_312.class)
public abstract class MouseMixin {
	@Shadow @Final private class_9928 scroller;
	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;isSpectator()Z"), method = "onMouseScroll", cancellable = true)
	private void perspective$onMouseScroll(long window, double horizontal, double vertical, CallbackInfo ci) {
		if (Perspective.isHoldingPerspective() && Perspective.isHoldingAdjust()) {
			boolean discreteMouseScroll = ClientData.minecraft.field_1690.method_42439().method_41753();
			double mouseWheelSensitivity = ClientData.minecraft.field_1690.method_41806().method_41753();
			double calculatedScroll = (discreteMouseScroll ? Math.signum(vertical) : vertical) * mouseWheelSensitivity;
			Vector2i vector2i = this.scroller.method_61971(calculatedScroll, calculatedScroll);
			if (vector2i.y != 0) {
				Perspective.adjust(-vector2i.y / 100.0F, PerspectiveConfig.config.holdPerspectiveMultiplierIncrementSize.value());
				ci.cancel();
			}
		}
	}
	@Inject(at = @At("HEAD"), method = "onMouseButton", cancellable = true)
	private void perspective$onMouseButton(long window, int button, int action, int mods, CallbackInfo ci) {
		if (Perspective.isHoldingPerspective() && Perspective.isHoldingAdjust()) {
			if (button == 2) {
				Perspective.reset();
				ci.cancel();
			}
		}
	}
}