/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_922;

@Mixin(priority = 100, value = class_922.class)
public abstract class LivingEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "shouldFlipUpsideDown", cancellable = true)
	private static void perspective$shouldFlipUpsideDown(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
		Optional<TexturedEntityEntry> data = TexturedEntity.getEntity(entity);
		if (data.isPresent()) {
			boolean shouldFlip = cir.getReturnValue();
			if (data.get().getFlip()) shouldFlip = !shouldFlip;
			cir.setReturnValue(shouldFlip);
		}
	}
}