/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import net.minecraft.class_10017;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4606;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_4606.class)
public class EyesFeatureRendererMixin<S extends class_10017> {
	@Unique
	private class_10017 state;
	@Inject(method = "render", at = @At("HEAD"))
	public void perspective$getEntity(class_4587 matrices, class_4597 vertexConsumers, int light, S state, float limbAngle, float limbDistance, CallbackInfo ci) {
		this.state = state;
	}
	@ModifyExpressionValue(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/feature/EyesFeatureRenderer;getEyesTexture()Lnet/minecraft/client/render/RenderLayer;"))
	public class_1921 perspective$render(class_1921 renderLayer) {
		class_2960 texture = null;
		class_1299<?> entityType = ((PerspectiveRenderState)state).perspective$getType();
		if (entityType.equals(class_1299.field_6091)) texture = class_2960.method_60654("textures/entity/enderman/enderman_eyes.png");
		else if (entityType.equals(class_1299.field_6079) || entityType.equals(class_1299.field_6084)) texture = class_2960.method_60654("textures/entity/spider_eyes.png");
		else if (entityType.equals(class_1299.field_6078)) texture = class_2960.method_60654("textures/entity/phantom_eyes.png");
		return texture != null ? class_1921.method_23026(TexturedEntity.getTexture(this.state, "", "_eyes", texture)) : renderLayer;
	}
}