/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.armor_stand;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.ArmorStandOverlayEntityModel;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import com.mclegoman.perspective.client.entity.renderer.feature.OverlayFeatureRenderer;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_1531;
import net.minecraft.class_2960;
import net.minecraft.class_548;
import net.minecraft.class_5617;
import net.minecraft.class_922;
import net.minecraft.class_9998;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = net.minecraft.class_877.class)
public abstract class ArmorStandEntityRendererMixin extends class_922<class_1531, class_9998, class_548> {
	public ArmorStandEntityRendererMixin(class_5617.class_5618 ctx, class_548 model, float shadowRadius) {
		super(ctx, model, shadowRadius);
	}
	@Inject(method = "<init>", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new OverlayFeatureRenderer(this, new ArmorStandOverlayEntityModel(context.method_32167(EntityModels.armorStandOverlay)), new ArmorStandOverlayEntityModel(context.method_32167(EntityModels.babyArmorStandOverlay)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/armor_stand/armor_stand_overlay.png")));
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/armor_stand/armor_stand_cape.png")).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/ArmorStandEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_9998 armorStandEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(armorStandEntityRenderState, cir.getReturnValue()));
	}
}