/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.axolotl;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10000;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

@Mixin(priority = 100, value = net.minecraft.class_5774.class)
public class AxolotlEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/AxolotlEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10000 entity, CallbackInfoReturnable<class_2960> cir) {
		if (entity != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(entity);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15281(entitySpecific, "variants", new JsonObject());
						if (variants.has(entity.field_53260.method_33238().toLowerCase())) {
							JsonObject typeRegistry = class_3518.method_15281(variants, entity.field_53260.method_33238().toLowerCase(), new JsonObject());
							isTexturedEntity = class_3518.method_15258(typeRegistry, "enabled", true);
						}
					}
				}
			}
			if (isTexturedEntity) {
				String variant = entity.field_53260.method_33238() != null ? "_" + entity.field_53260.method_33238().toLowerCase() : "";
				cir.setReturnValue(TexturedEntity.getTexture(entity, "", variant, cir.getReturnValue()));
			}
		}
	}
}