/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.bee;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.renderer.feature.OverlayFeatureRenderer;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_10002;
import net.minecraft.class_2960;
import net.minecraft.class_4466;
import net.minecraft.class_4495;
import net.minecraft.class_4505;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_4505.class)
public abstract class BeeEntityRendererMixin extends class_927<class_4466, class_10002, class_4495> {
	@Shadow @Final private static class_2960 ANGRY_NECTAR_TEXTURE;
	@Shadow @Final private static class_2960 ANGRY_TEXTURE;
	@Shadow @Final private static class_2960 PASSIVE_TEXTURE;
	@Shadow @Final private static class_2960 NECTAR_TEXTURE;
	public BeeEntityRendererMixin(class_5617.class_5618 context, class_4495 entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new OverlayFeatureRenderer<>(this, new class_4495(context.method_32167(EntityModels.beeOverlay)), new class_4495(context.method_32167(EntityModels.babyBeeOverlay)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/bee/bee_overlay.png")));
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/BeeEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10002 entity, CallbackInfoReturnable<class_2960> cir) {
		if (entity.field_53271) {
			if (entity.field_53272) cir.setReturnValue(TexturedEntity.getTexture(entity, "", "_angry_nectar", ANGRY_NECTAR_TEXTURE));
			else cir.setReturnValue(TexturedEntity.getTexture(entity, "", "_angry", ANGRY_TEXTURE));
		} else {
			if (entity.field_53272) cir.setReturnValue(TexturedEntity.getTexture(entity, "", "_nectar", NECTAR_TEXTURE));
			else cir.setReturnValue(TexturedEntity.getTexture(entity, PASSIVE_TEXTURE));
		}
	}
}