/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.cat;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.states.PerspectiveTamedRenderState;
import com.mclegoman.perspective.client.entity.states.PerspectiveVariantRenderState;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10008;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

@Mixin(priority = 100, value = net.minecraft.class_929.class)
public class CatEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/CatEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10008 state, CallbackInfoReturnable<class_2960> cir) {
		if (state != null) {
			boolean isTexturedEntity = true;
			String variant = ((PerspectiveVariantRenderState)state).perspective$getVariantId();
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(state);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (entitySpecific.has(variant.toLowerCase())) {
								JsonObject typeRegistry = class_3518.method_15296(variants, variant.toLowerCase());
								if (typeRegistry != null) {
									isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(typeRegistry, "enabled", true));
								}
							}
						}
					}
					if (entitySpecific.has("tamed")) {
						isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(entitySpecific, "tamed", true));
					}
				}
			}
			if (isTexturedEntity) {
				String variantNamespace = variant != null ? IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, variant) : "minecraft";
				String variantKey = variant != null ? "_" + IdentifierHelper.getStringPart(IdentifierHelper.Type.KEY, variant) : "";
				cir.setReturnValue(((PerspectiveTamedRenderState)state).perspective$getTamed() ? TexturedEntity.getTexture(state, variantNamespace, "", variantKey + "_tame", cir.getReturnValue()) : TexturedEntity.getTexture(state, variantNamespace, "", variantKey, cir.getReturnValue()));
			}
		}
	}
}