/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.drowned;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import net.minecraft.class_10086;
import net.minecraft.class_1551;
import net.minecraft.class_2960;
import net.minecraft.class_5617;
import net.minecraft.class_564;
import net.minecraft.class_890;
import net.minecraft.class_968;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_890.class)
public abstract class DrownedEntityRendererMixin extends class_968<class_1551, class_10086, class_564> {
	protected DrownedEntityRendererMixin(class_5617.class_5618 context, class_564 mainModel, class_564 babyMainModel, class_564 armorInnerModel, class_564 armorOuterModel, class_564 babyArmorInnerModel, class_564 babyArmorOuterModel) {
		super(context, mainModel, babyMainModel, armorInnerModel, armorOuterModel, babyArmorInnerModel, babyArmorOuterModel);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/zombie/drowned_cape.png")).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/ZombieEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10086 entity, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(entity, cir.getReturnValue()));
	}
}