/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.fox;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10027;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4019;
import net.minecraft.class_4041;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_927;

@Mixin(priority = 100, value = net.minecraft.class_4042.class)
public abstract class FoxEntityRendererMixin extends class_927<class_4019, class_10027, class_4041> {
	public FoxEntityRendererMixin(class_5617.class_5618 context, class_4041 entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/fox/fox_cape.png")).offsetZ(-0.1225F).offsetY(0.845F).rotation(class_7833.field_40714.rotationDegrees(90.0F).scale(0.8F)).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/FoxEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10027 entity, CallbackInfoReturnable<class_2960> cir) {
		if (entity != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(entity);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (variants.has(entity.field_53378.method_15434().toLowerCase())) {
								JsonObject typeRegistry = class_3518.method_15296(variants, entity.field_53378.method_15434().toLowerCase());
								if (typeRegistry != null) {
									isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(typeRegistry, "enabled", true));
								}
							}
						}
					}
				}
				if (isTexturedEntity) {
					String variant = entity.field_53378 != null ? "_" + entity.field_53378.method_15434() : "";
					cir.setReturnValue(entity.field_53374 ? TexturedEntity.getTexture(entity, "", variant + "_sleep", cir.getReturnValue()) : TexturedEntity.getTexture(entity, "", variant, cir.getReturnValue()));
				}
			}
		}
	}
}