/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.frog;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.states.PerspectiveVariantRenderState;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10028;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

@Mixin(priority = 100, value = net.minecraft.class_7213.class)
public class FrogEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/FrogEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10028 frogEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		if (frogEntityRenderState != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(frogEntityRenderState);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (entitySpecific.has((((PerspectiveVariantRenderState)frogEntityRenderState).perspective$getVariantId()).toLowerCase())) {
								JsonObject typeRegistry = class_3518.method_15296(variants, (((PerspectiveVariantRenderState)frogEntityRenderState).perspective$getVariantId()).toLowerCase());
								if (typeRegistry != null) {
									isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(typeRegistry, "enabled", true));
								}
							}
						}
					}
				}
				if (isTexturedEntity) {
					String variant = (((PerspectiveVariantRenderState)frogEntityRenderState).perspective$getVariantId());
					if (variant != null) cir.setReturnValue(TexturedEntity.getTexture(frogEntityRenderState, IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, variant), cir.getReturnValue()));
				}
			}
		}
	}
}