/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.giant;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import com.mclegoman.perspective.client.entity.renderer.feature.OverlayFeatureRenderer;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_10086;
import net.minecraft.class_1570;
import net.minecraft.class_2960;
import net.minecraft.class_3969;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_927;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = net.minecraft.class_908.class)
public abstract class GiantEntityRendererMixin extends class_927<class_1570, class_10086, class_572<class_10086>> {
	public GiantEntityRendererMixin(class_5617.class_5618 context, class_572<class_10086> entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, float scale, CallbackInfo ci) {
		this.method_4046(new OverlayFeatureRenderer<>(this, new class_3969(context.method_32167(EntityModels.giantOverlay)), null, class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/zombie/zombie_overlay.png")));
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/zombie/zombie_cape.png")).scale(6.0F).offsetY(-1.25F).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/ZombieEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10086 entity, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(entity, cir.getReturnValue()));
	}
}