/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.glow_squid;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.minecraft.class_10069;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = net.minecraft.class_5789.class)
public class GlowSquidEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/SquidEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10069 squidEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(squidEntityRenderState, cir.getReturnValue()));
	}
}